/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemVaultFruit
extends Item {
    public static final UUID MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("94574f3d-49dc-4fc5-8ca5-74707eb1c34d");
    public static FoodProperties VAULT_FRUIT_FOOD = new FoodProperties.Builder().m_38758_(0.0f).m_38760_(0).m_38766_().m_38765_().m_38767_();
    protected int extraVaultTicks;

    public ItemVaultFruit(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
        super(new Item.Properties().m_41491_(group).m_41489_(VAULT_FRUIT_FOOD).m_41487_(64));
        this.setRegistryName(id);
        this.extraVaultTicks = extraVaultTicks;
    }

    public boolean onEaten(Level level, Player player) {
        CommonEvents.FRUIT_EATEN.invoke(this, player, this.extraVaultTicks);
        return true;
    }

    public int getExtraVaultTicks() {
        return this.extraVaultTicks;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_ && ServerVaults.get(level).isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!this.isPlayerMaxHealthGreaterThan(player, 2)) {
            if (player.f_19853_.f_46443_) {
                player.m_5661_((Component)new TextComponent("Your max health is too low to eat this!").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return super.m_7203_(level, player, hand);
    }

    @ParametersAreNonnullByDefault
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)new TextComponent(""));
        TextComponent textComponent = new TextComponent("[!] Only edible inside a Vault");
        textComponent.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131155_(Boolean.valueOf(true)));
        tooltip.add((Component)textComponent);
        super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack itemStack) {
        MutableComponent displayName = (MutableComponent)super.m_7626_(itemStack);
        return displayName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16563456)));
    }

    protected boolean isPlayerMaxHealthGreaterThan(Player player, int threshold) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22276_);
        if (attributeInstance == null) {
            return false;
        }
        return attributeInstance.m_22135_() > (double)threshold;
    }

    protected void reducePlayerMaxHealth(ServerPlayer serverPlayer) {
        this.reducePlayerMaxHealth(serverPlayer, 0.1f, 2);
    }

    protected void reducePlayerMaxHealth(ServerPlayer serverPlayer, float percentageReduction, int minimumReduction) {
        AttributeInstance attributeInstance = serverPlayer.m_21051_(Attributes.f_22276_);
        if (attributeInstance == null) {
            return;
        }
        AttributeModifier existingModifier = attributeInstance.m_22111_(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID);
        double reductionAmount = 0.0;
        if (existingModifier != null) {
            reductionAmount += existingModifier.m_22218_();
            attributeInstance.m_22120_(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID);
        }
        attributeInstance.m_22125_(new AttributeModifier(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID, "VaultFruitMaxHealthReduction", reductionAmount -= Math.max((double)minimumReduction, attributeInstance.m_22135_() * (double)percentageReduction), AttributeModifier.Operation.ADDITION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT || event.player.m_183503_().m_46467_() % 10L != 0L || ServerVaults.get(event.player.f_19853_).isPresent()) {
            return;
        }
        Player player = event.player;
        synchronized (player) {
            AttributeInstance attributeInstance = event.player.m_21051_(Attributes.f_22276_);
            if (attributeInstance != null) {
                attributeInstance.m_22120_(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID);
            }
        }
    }

    public static class SweetKiwi
    extends ItemVaultFruit {
        public SweetKiwi(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
            if (!level.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(level, (Player)player)) {
                    this.reducePlayerMaxHealth(player);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, level, entityLiving);
        }

        @Override
        @ParametersAreNonnullByDefault
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tooltipFlag) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("- Removes 10% max health");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 10 seconds to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
        }
    }

    public static class MysticPear
    extends ItemVaultFruit {
        public MysticPear(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
            if (!worldIn.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(worldIn, (Player)player)) {
                    this.reducePlayerMaxHealth(player);
                    if (MathUtilities.randomFloat(0.0f, 100.0f) <= 50.0f) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600));
                    } else {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 600));
                    }
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, worldIn, entityLiving);
        }

        @Override
        @ParametersAreNonnullByDefault
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tooltipFlag) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("A magical pear with a strange taste");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            comp = new TextComponent("It is grown on the gorgeous trees of Iskallia.");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            tooltip.add((Component)new TextComponent(""));
            comp = new TextComponent("- Removes 10% max health");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Inflicts with either Wither or Poison effect");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 5 minutes to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
        }
    }

    public static class SourOrange
    extends ItemVaultFruit {
        public SourOrange(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
            if (!level.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(level, (Player)player)) {
                    this.reducePlayerMaxHealth(player);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, level, entityLiving);
        }

        @Override
        @ParametersAreNonnullByDefault
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("A magical orange with a sour taste");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            comp = new TextComponent("It is grown on the gorgeous trees of Iskallia.");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            tooltip.add((Component)new TextComponent(""));
            comp = new TextComponent("- Removes 10% max health");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 60 seconds to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(itemStack, level, tooltip, tooltipFlag);
        }
    }

    public static class BitterLemon
    extends ItemVaultFruit {
        public BitterLemon(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
            if (!level.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(level, (Player)player)) {
                    this.reducePlayerMaxHealth(player);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, level, entityLiving);
        }

        @Override
        @ParametersAreNonnullByDefault
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("A magical lemon with a bitter taste");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            comp = new TextComponent("It is grown on the gorgeous trees of Iskallia.");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            tooltip.add((Component)new TextComponent(""));
            comp = new TextComponent("- Removes 10% max health");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 30 seconds to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(itemStack, level, tooltip, tooltipFlag);
        }
    }
}

