/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.dynamodel.model.item.PlainItemModel;
import iskallia.vault.event.InputEvents;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModRelics;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RelicFragmentItem
extends Item
implements DynamicModelItem {
    public RelicFragmentItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(64));
        this.setRegistryName(id);
    }

    @Override
    public Optional<ResourceLocation> getDynamicModelId(ItemStack itemStack) {
        return DynamicModelItem.getGenericModelId(itemStack);
    }

    public void m_6787_(@Nonnull CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(category)) {
            ModRelics.RECIPE_REGISTRY.values().forEach(relicRecipe -> relicRecipe.getFragments().forEach(fragmentId -> {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                DynamicModelItem.setGenericModelId(itemStack, fragmentId);
                items.add((Object)itemStack);
            }));
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack itemStack) {
        ResourceLocation modelId = DynamicModelItem.getGenericModelId(itemStack).orElse(null);
        if (modelId == null) {
            return super.m_7626_(itemStack);
        }
        PlainItemModel itemModel = ModDynamicModels.Relics.FRAGMENT_REGISTRY.get(modelId).orElse(null);
        if (itemModel == null) {
            return super.m_7626_(itemStack);
        }
        return new TextComponent(itemModel.getDisplayName() + " (Relic Fragment)").m_130948_(Style.f_131099_.m_178520_(-2505149));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        DynamicModelItem.getGenericModelId(stack).flatMap(ModDynamicModels.Relics.FRAGMENT_REGISTRY::get).map(DynamicModel::getId).flatMap(ModRelics::getRelicOfFragment).map(ModRelics.RelicRecipe::getResultingRelic).flatMap(ModDynamicModels.Relics.RELIC_REGISTRY::get).ifPresent(relicModel -> {
            tooltip.add((Component)new TextComponent("Assembles: ").m_7220_((Component)new TextComponent(relicModel.getDisplayName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-3755746)))));
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TextComponent("Craft a Relic Pedestal to assemble").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TextComponent("this fragment into a Relic").m_130940_(ChatFormatting.GRAY));
            if (flag.m_7050_()) {
                if (InputEvents.isShiftDown()) {
                    ResourceLocation fragmentId = DynamicModelItem.getGenericModelId(stack).orElse(ModRelics.EMPTY.getResultingRelic());
                    tooltip.add((Component)new TextComponent(""));
                    tooltip.add((Component)new TextComponent("Relic Fragment Id: "));
                    tooltip.add((Component)new TextComponent(fragmentId.toString()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-3755746))));
                } else {
                    tooltip.add((Component)new TextComponent("Press <SHIFT> for fragment id").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
                }
            }
        });
        super.m_7373_(stack, world, tooltip, flag);
    }
}

