/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RokkitLaunchaItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> FIREWORKS_ONLY = itemStack -> itemStack.m_150930_(Items.f_42688_);

    public RokkitLaunchaItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    @Nonnull
    public Predicate<ItemStack> m_6437_() {
        return FIREWORKS_ONLY;
    }

    public int m_6615_() {
        return 8;
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return Rarity.EPIC;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack launcherStack = player.m_21120_(hand);
        ItemStack ammoStack = player.m_6298_(launcherStack);
        if (ammoStack.m_41619_()) {
            world.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12448_, SoundSource.MASTER, 1.0f, 1.2f, false);
            Vec3 upVector = player.m_20289_(1.0f);
            Vector3f viewVector = new Vector3f(player.m_20252_(1.0f));
            viewVector.m_122253_(new Vector3f(upVector));
            for (int i = 0; i < 5; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_() + (double)viewVector.m_122239_() + (double)(world.f_46441_.nextFloat() * 0.5f), player.m_20186_() + (double)viewVector.m_122260_() + (double)(world.f_46441_.nextFloat() * 0.5f), player.m_20189_() + (double)viewVector.m_122269_() + (double)(world.f_46441_.nextFloat() * 0.5f), 0.0, (double)0.1f, 0.0);
            }
            player.m_5661_((Component)new TextComponent("Rokkit Launcha requires Fireworks as ammo.").m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)launcherStack);
        }
        player.m_36335_().m_41524_((Item)this, 100);
        if (!world.m_5776_()) {
            RokkitLaunchaItem.performShooting(world, player, hand, launcherStack, 1.0f, 1.0f);
            return InteractionResultHolder.m_19096_((Object)launcherStack);
        }
        return super.m_7203_(world, player, hand);
    }

    public static void performShooting(Level world, Player player, InteractionHand hand, ItemStack launcherStack, float velocity, float inaccuracy) {
        ItemStack ammoStack = player.m_6298_(launcherStack);
        float[] pitches = RokkitLaunchaItem.getShotPitches(player.m_21187_());
        if (!ammoStack.m_41619_()) {
            RokkitLaunchaItem.shootProjectile(world, player, hand, launcherStack, ammoStack, pitches[0], velocity, inaccuracy, -10.0f);
            RokkitLaunchaItem.shootProjectile(world, player, hand, launcherStack, ammoStack, pitches[1], velocity, inaccuracy, 0.0f);
            RokkitLaunchaItem.shootProjectile(world, player, hand, launcherStack, ammoStack, pitches[2], velocity, inaccuracy, 10.0f);
            if (!player.m_7500_()) {
                ammoStack.m_41774_(1);
            }
        }
    }

    private static void shootProjectile(Level world, Player player, InteractionHand hand, ItemStack shooterStack, ItemStack ammoStack, float pSoundPitch, float velocity, float inaccuracy, float angle) {
        if (!world.f_46443_) {
            FireworkRocketEntity projectile = new FireworkRocketEntity(world, ammoStack, (Entity)player, player.m_20185_(), player.m_20188_() - (double)0.15f, player.m_20189_(), true);
            Vec3 upVector = player.m_20289_(1.0f);
            Quaternion quaternion = new Quaternion(new Vector3f(upVector), angle, true);
            Vector3f viewVector = new Vector3f(player.m_20252_(1.0f));
            viewVector.m_122251_(quaternion);
            projectile.m_6686_((double)viewVector.m_122239_(), (double)viewVector.m_122260_(), (double)viewVector.m_122269_(), velocity, inaccuracy);
            shooterStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            world.m_7967_((Entity)projectile);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11933_, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    private static float[] getShotPitches(Random pRandom) {
        boolean highPitches = pRandom.nextBoolean();
        return new float[]{1.0f, RokkitLaunchaItem.getRandomShotPitch(highPitches, pRandom), RokkitLaunchaItem.getRandomShotPitch(!highPitches, pRandom)};
    }

    private static float getRandomShotPitch(boolean pIsHighPitched, Random pRandom) {
        float f = pIsHighPitched ? 0.63f : 0.43f;
        return 1.0f / (pRandom.nextFloat() * 0.5f + 1.8f) + f;
    }
}

