/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.authlib.GameProfile;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.client.render.DollISTER;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.event.common.CrateAwardEvent;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.BasicItem;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.DollLootData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultPartyData;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VaultDollItem
extends BasicItem {
    private static final String PLAYER_PROFILE_TAG = "playerProfile";
    private static final String VAULT_UUID_TAG = "vaultUUID";
    private static final String XP_POINTS_TAG = "xpPoints";
    private static final String XP_PERCENT_TAG = "xpPercent";
    private static final String LOOT_PERCENT_TAG = "lootPercent";

    public VaultDollItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
        CommonEvents.CHEST_LOOT_GENERATION.register((Object)this, this::handleChestLoot, -1);
        CommonEvents.COIN_STACK_LOOT_GENERATION.register((Object)this, this::handleCoinStackLoot, -1);
        CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.register((Object)this, this::handleLootableBlockLoot, -1);
        CommonEvents.CRATE_AWARD_EVENT.register((Object)this, this::handleCrateLoot, -1);
    }

    private void handleCrateLoot(CrateAwardEvent.Data data) {
        if (data.getPhase() == CrateAwardEvent.Phase.PRE) {
            Vault vault;
            UUID vaultId;
            ServerLevel serverLevel;
            ServerPlayer player = data.getPlayer();
            ItemStack doll = VaultDollItem.getFirstDollMatching((Player)player, arg_0 -> this.lambda$handleCrateLoot$0(serverLevel = player.m_183503_(), player, vaultId = (vault = data.getVault()).get(Vault.ID), arg_0));
            if (doll.m_41619_()) {
                return;
            }
            VaultDollItem.getDollUUID(doll).ifPresent(dollId -> {
                float percentage = VaultDollItem.getLootPercent(doll);
                if (data.getRandom().nextFloat() < percentage) {
                    NonNullList<ItemStack> items = data.getCrateLootGenerator().generate(vault, data.getListener(), data.getRandom());
                    ItemStack crate = VaultCrateBlock.getCrateWithLoot(data.getCrateType(), items);
                    DollLootData.get(serverLevel, dollId).addLoot(crate);
                }
            });
        }
    }

    private void handleLootableBlockLoot(LootableBlockGenerationEvent.Data data) {
        if (data.getPhase() == LootableBlockGenerationEvent.Phase.POST) {
            this.handleLoot(data.getPlayer(), data::getLoot);
        }
    }

    private void handleCoinStackLoot(CoinStacksGenerationEvent.Data data) {
        if (data.getPhase() == CoinStacksGenerationEvent.Phase.POST) {
            this.handleLoot(data.getPlayer(), data::getLoot);
        }
    }

    private void handleChestLoot(ChestGenerationEvent.Data data) {
        if (data.getPhase() == ChestGenerationEvent.Phase.POST) {
            this.handleLoot(data.getPlayer(), data::getLoot);
        }
    }

    private void handleLoot(ServerPlayer player, Supplier<List<ItemStack>> getLoot) {
        if (player == null) {
            return;
        }
        ServerLevel serverLevel = player.m_183503_();
        VaultDollItem.getPlayerVaultId(serverLevel).ifPresent(vaultId -> {
            ItemStack doll = VaultDollItem.getFirstDollMatching((Player)player, stack -> VaultDollItem.isDollOwnedByDifferentPlayer(serverLevel, stack, (Player)player) && this.isTheSameVault((ItemStack)stack, (UUID)vaultId));
            if (doll.m_41619_()) {
                return;
            }
            VaultDollItem.getDollUUID(doll).ifPresent(arg_0 -> VaultDollItem.lambda$handleLoot$3(serverLevel, doll, (Supplier)getLoot, arg_0));
        });
    }

    @SubscribeEvent
    public static void onDollTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() != ModItems.VAULT_DOLL) {
            return;
        }
        List tooltip = event.getToolTip();
        VaultDollItem.getPlayerGameProfile(stack).ifPresent(gp -> {
            tooltip.add(1, new TranslatableComponent("tooltip.the_vault.doll_owner", new Object[]{new TextComponent(gp.getName()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
            float lootPercent = VaultDollItem.getLootPercent(stack);
            ChatFormatting lootColor = VaultDollItem.getRangeBasedColor(lootPercent, ModConfigs.VAULT_ITEMS.VAULT_DOLL.lootPercentageMin, ModConfigs.VAULT_ITEMS.VAULT_DOLL.lootPercentageMax);
            tooltip.add(2, new TranslatableComponent("tooltip.the_vault.doll_loot_efficiency", new Object[]{new TextComponent(String.format("%d", (int)(lootPercent * 100.0f)) + "%").m_130940_(lootColor)}).m_130940_(ChatFormatting.GRAY));
            float xpPercent = VaultDollItem.getXpPercent(stack);
            ChatFormatting xpColor = VaultDollItem.getRangeBasedColor(xpPercent, ModConfigs.VAULT_ITEMS.VAULT_DOLL.xpPercentageMin, ModConfigs.VAULT_ITEMS.VAULT_DOLL.xpPercentageMax);
            tooltip.add(3, new TranslatableComponent("tooltip.the_vault.doll_experience_efficiency", new Object[]{new TextComponent(String.format("%d", (int)(xpPercent * 100.0f)) + "%").m_130940_(xpColor)}).m_130940_(ChatFormatting.GRAY));
            Player player = event.getPlayer();
            if (player != null) {
                VaultDollItem.getVaultUUID(stack).ifPresentOrElse(vaultId -> {
                    boolean isInThisVault = ClientVaults.getActive().map(vault -> vaultId.equals(vault.get(Vault.ID))).orElse(false);
                    if (isInThisVault) {
                        tooltip.add(4, new TranslatableComponent("tooltip.the_vault.doll_status.active").m_130940_(ChatFormatting.YELLOW));
                    } else {
                        tooltip.add(4, new TranslatableComponent("tooltip.the_vault.doll_status.completed_by", new Object[]{VaultDollItem.getCompletedBy(stack), VaultDollItem.getVaultLevel(stack)}).m_130940_(ChatFormatting.GRAY));
                        tooltip.add(5, new TranslatableComponent("tooltip.the_vault.doll_status.completed").m_130940_(ChatFormatting.GREEN));
                    }
                }, () -> tooltip.add(4, new TranslatableComponent("tooltip.the_vault.doll_status.ready").m_130940_(ChatFormatting.WHITE)));
            }
        });
    }

    private static String getCompletedBy(ItemStack doll) {
        return doll.m_41784_().m_128461_("completedBy");
    }

    private static int getVaultLevel(ItemStack doll) {
        return doll.m_41784_().m_128451_("vaultLevel");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onOreBroken(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        if (!(state.m_60734_() instanceof VaultOreBlock) || !((Boolean)state.m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        Level level = player.m_183503_();
        if (player.m_7500_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        VaultDollItem.getPlayerVaultId(serverLevel).ifPresent(vaultId -> {
            ItemStack doll = VaultDollItem.getFirstDollMatching(player, stack -> VaultDollItem.isDollSetToVault(stack, vaultId));
            if (!doll.m_41619_()) {
                VaultDollItem.addPercentageOfBlockDrops(event, state, player, level, serverLevel, doll);
            }
        });
    }

    private static void addPercentageOfBlockDrops(BlockEvent.BreakEvent event, BlockState state, Player player, Level level, ServerLevel serverLevel, ItemStack doll) {
        BlockPos pos = event.getPos();
        ItemStack tool = event.getPlayer().m_21205_();
        VaultDollItem.getDollUUID(doll).ifPresent(dollId -> {
            LootContext.Builder lootContext = new LootContext.Builder(serverLevel).m_78977_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78984_(LootContextParams.f_81455_, (Object)player).m_78984_(LootContextParams.f_81462_, null);
            List drops = state.m_60734_().m_7381_(state, lootContext);
            VaultDollItem.addPercentageOfLoot(serverLevel, doll, dollId, drops);
        });
    }

    private static ChatFormatting getRangeBasedColor(float value, float min, float max) {
        float thirdOfRange = (max - min) / 3.0f;
        if (value < min + thirdOfRange) {
            return ChatFormatting.RED;
        }
        if (value < max - thirdOfRange) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.GREEN;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        VaultDollItem.setNewDollAttributes(stack, player);
    }

    private static Optional<UUID> getPlayerVaultId(ServerLevel serverLevel) {
        return ServerVaults.get((Level)serverLevel).map(vault -> vault.get(Vault.ID));
    }

    public static void markDollOnVaultJoin(VirtualWorld world, Player player, UUID vaultId) {
        ItemStack doll = VaultDollItem.getFirstDollMatching(player, stack -> VaultDollItem.isDollOwnedByDifferentPlayer(world, stack, player) && VaultDollItem.getVaultUUID(stack).isEmpty());
        if (!doll.m_41619_()) {
            VaultDollItem.setVaultUUID(doll, vaultId);
        }
    }

    public static void onVaultCompletion(Player player, UUID vaultId, int vaultLevel, int experiencePoints) {
        ItemStack doll = VaultDollItem.getFirstDollMatching(player, stack -> VaultDollItem.isDollSetToVault(stack, vaultId));
        if (!doll.m_41619_()) {
            float xpPercentage = VaultDollItem.getXpPercent(doll);
            VaultDollItem.setExperience(doll, (int)(xpPercentage * (float)experiencePoints));
            VaultDollItem.setCompletedBy(doll, player.m_5446_().getString(), vaultLevel);
        }
    }

    private static boolean isDollSetToVault(ItemStack stack, UUID vaultId) {
        return stack.m_41720_() == ModItems.VAULT_DOLL && VaultDollItem.getVaultUUID(stack).map(uuid -> uuid.equals(vaultId)).orElse(false) != false;
    }

    private static void setExperience(ItemStack doll, int experiencePoints) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            doll.m_41784_().m_128405_(XP_POINTS_TAG, experiencePoints);
        }
    }

    public static int getExperience(CompoundTag tag) {
        return tag.m_128451_(XP_POINTS_TAG);
    }

    private static void addPercentageOfLoot(ServerLevel serverLevel, ItemStack doll, UUID dollId, List<ItemStack> items) {
        float percentage = VaultDollItem.getLootPercent(doll);
        items.forEach(stack -> {
            if (serverLevel.f_46441_.nextFloat() < percentage) {
                DollLootData.get(serverLevel, dollId).addLoot(stack.m_41777_());
            }
        });
    }

    private static ItemStack getFirstDollMatching(Player player, Predicate<ItemStack> stackMatcher) {
        ItemStack result;
        if (ModList.get().isLoaded("curios") && !(result = IntegrationCurios.getItemFromCuriosHeadSlot(player, stackMatcher)).m_41619_()) {
            return result;
        }
        result = VaultDollItem.getFromInventory((NonNullList<ItemStack>)player.m_150109_().f_35976_, stackMatcher);
        if (!result.m_41619_()) {
            return result;
        }
        result = VaultDollItem.getFromInventory((NonNullList<ItemStack>)player.m_150109_().f_35974_, stackMatcher);
        return result;
    }

    private static boolean isDollOwnedByDifferentPlayer(ServerLevel serverLevel, ItemStack stack, Player player) {
        return stack.m_41720_() == ModItems.VAULT_DOLL && VaultDollItem.getPlayerUUID(stack).map(dollOnwerId -> !dollOnwerId.equals(player.m_142081_()) && VaultDollItem.isDollOwnedByPlayerNotInPartyWithPlayer(serverLevel, dollOnwerId, player.m_142081_())).orElse(false) != false;
    }

    private static boolean isDollOwnedByPlayerNotInPartyWithPlayer(ServerLevel serverLevel, UUID dollOwnerId, UUID playerId) {
        return VaultPartyData.get(serverLevel).getParty(playerId).map(party -> !party.hasMember(dollOwnerId)).orElse(true);
    }

    private boolean isTheSameVault(ItemStack stack, UUID vaultId) {
        return VaultDollItem.getVaultUUID(stack).map(uuid -> uuid.equals(vaultId)).orElse(false);
    }

    private static ItemStack getFromInventory(NonNullList<ItemStack> inventoryStacks, Predicate<ItemStack> stackMatcher) {
        for (ItemStack itemStack : inventoryStacks) {
            if (!stackMatcher.test(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static void setNewDollAttributes(ItemStack doll, Player player) {
        VaultDollItem.setNewDollAttributes(doll, player.m_36316_(), player.m_183503_());
    }

    public static void setNewDollAttributes(ItemStack doll, GameProfile gameProfile, Level level) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            CompoundTag tag = doll.m_41784_();
            VaultDollItem.setGameProfile(tag, gameProfile);
            VaultDollItem.setRandomChances(tag, level);
        }
    }

    private static void setRandomChances(CompoundTag tag, Level level) {
        tag.m_128350_(XP_PERCENT_TAG, level.f_46441_.nextFloat(ModConfigs.VAULT_ITEMS.VAULT_DOLL.xpPercentageMin, ModConfigs.VAULT_ITEMS.VAULT_DOLL.xpPercentageMax));
        tag.m_128350_(LOOT_PERCENT_TAG, level.f_46441_.nextFloat(ModConfigs.VAULT_ITEMS.VAULT_DOLL.lootPercentageMin, ModConfigs.VAULT_ITEMS.VAULT_DOLL.lootPercentageMax));
    }

    private static float getXpPercent(ItemStack doll) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            return doll.m_41784_().m_128457_(XP_PERCENT_TAG);
        }
        return 0.0f;
    }

    private static float getLootPercent(ItemStack doll) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            return doll.m_41784_().m_128457_(LOOT_PERCENT_TAG);
        }
        return 0.0f;
    }

    public static void setGameProfile(CompoundTag tag, GameProfile gameProfile) {
        tag.m_128365_(PLAYER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameProfile));
    }

    private static void setCompletedBy(ItemStack doll, String completedBy, int vaultLevel) {
        CompoundTag tag = doll.m_41784_();
        tag.m_128359_("completedBy", completedBy);
        tag.m_128405_("vaultLevel", vaultLevel);
    }

    public static Optional<GameProfile> getPlayerGameProfile(ItemStack doll) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            return VaultDollItem.getPlayerGameProfile(doll.m_41784_());
        }
        return Optional.empty();
    }

    public static Optional<GameProfile> getPlayerGameProfile(@Nullable CompoundTag tag) {
        if (tag != null && tag.m_128441_(PLAYER_PROFILE_TAG)) {
            return Optional.ofNullable(NbtUtils.m_129228_((CompoundTag)tag.m_128469_(PLAYER_PROFILE_TAG)));
        }
        return Optional.empty();
    }

    private static Optional<UUID> getDollUUID(ItemStack doll) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            CompoundTag tag = doll.m_41784_();
            return VaultDollItem.getDollUUID(tag);
        }
        return Optional.empty();
    }

    public static Optional<UUID> getDollUUID(CompoundTag tag) {
        Optional<UUID> vaultUUID = VaultDollItem.getUUID(tag, VAULT_UUID_TAG);
        Optional playerUUID = VaultDollItem.getPlayerGameProfile(tag).flatMap(gp -> Optional.of(gp.getId()));
        return vaultUUID.isPresent() && playerUUID.isPresent() ? Optional.of(new UUID(vaultUUID.get().getMostSignificantBits(), ((UUID)playerUUID.get()).getLeastSignificantBits())) : Optional.empty();
    }

    private static Optional<UUID> getPlayerUUID(ItemStack doll) {
        return VaultDollItem.getPlayerGameProfile(doll).flatMap(gp -> Optional.of(gp.getId()));
    }

    private static Optional<UUID> getUUID(ItemStack doll, String uuidTag) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            CompoundTag tag = doll.m_41784_();
            return VaultDollItem.getUUID(tag, uuidTag);
        }
        return Optional.empty();
    }

    private static Optional<UUID> getUUID(CompoundTag tag, String uuidTag) {
        if (!tag.m_128441_(uuidTag)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128342_(uuidTag));
    }

    private static void setVaultUUID(ItemStack doll, UUID vaultId) {
        if (doll.m_41720_() instanceof VaultDollItem) {
            CompoundTag tag = doll.m_41784_();
            tag.m_128362_(VAULT_UUID_TAG, vaultId);
        }
    }

    private static Optional<UUID> getVaultUUID(ItemStack doll) {
        return VaultDollItem.getUUID(doll, VAULT_UUID_TAG);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return DollISTER.INSTANCE;
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (player == null || ServerVaults.get(player.f_19853_).isPresent() || VHSmpUtil.isArenaWorld((Entity)player) || VaultDollItem.getVaultUUID(stack).isEmpty() || this.playerCannotPlaceDoll(stack, player)) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos clickedPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = level.m_8055_(clickedPos);
        BlockPos placementPos = blockstate.m_60812_((BlockGetter)level, clickedPos).m_83281_() ? clickedPos : clickedPos.m_142300_(direction);
        if (ModEntities.DOLL_MINI_ME.m_20592_(serverLevel, stack, player, placementPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(clickedPos, placementPos) && direction == Direction.UP) != null) {
            stack.m_41774_(1);
            level.m_142346_((Entity)player, GameEvent.f_157810_, clickedPos);
        }
        return InteractionResult.CONSUME;
    }

    private boolean playerCannotPlaceDoll(ItemStack stack, Player player) {
        return !player.m_7500_() && VaultDollItem.getPlayerUUID(stack).map(uuid -> !uuid.equals(player.m_142081_())).orElse(true) != false;
    }

    private static /* synthetic */ void lambda$handleLoot$3(ServerLevel serverLevel, ItemStack doll, Supplier getLoot, UUID dollId) {
        VaultDollItem.addPercentageOfLoot(serverLevel, doll, dollId, (List)getLoot.get());
    }

    private /* synthetic */ boolean lambda$handleCrateLoot$0(ServerLevel serverLevel, ServerPlayer player, UUID vaultId, ItemStack stack) {
        return VaultDollItem.isDollOwnedByDifferentPlayer(serverLevel, stack, (Player)player) && this.isTheSameVault(stack, vaultId);
    }
}

