/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.item.bottle.AbsorptionBottleEffect;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.item.bottle.CastAbilityBottleEffect;
import iskallia.vault.item.bottle.CleanseBottleEffect;
import iskallia.vault.item.bottle.CooldownReductionBottleEffect;
import iskallia.vault.item.bottle.ManaFlatBottleEffect;
import iskallia.vault.item.bottle.ManaPercentBottleEffect;
import iskallia.vault.item.bottle.PotionBottleEffect;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;

public class BottleEffectManager {
    private static final Map<String, BiFunction<String, CompoundTag, BottleEffect>> REGISTRY = Map.of("mana_flat", ManaFlatBottleEffect::deserialize, "mana_percent", ManaPercentBottleEffect::deserialize, "cooldown_reduction", CooldownReductionBottleEffect::deserialize, "potion", PotionBottleEffect::deserialize, "absorption", AbsorptionBottleEffect::deserialize, "cleanse", CleanseBottleEffect::deserialize, "cast_ability", CastAbilityBottleEffect::deserialize);

    private BottleEffectManager() {
    }

    public static Optional<BottleEffect> deserialize(CompoundTag tag) {
        String effectId = tag.m_128461_("id");
        String type = tag.m_128461_("type");
        return BottleEffectManager.deserialize(type, effectId, tag);
    }

    public static Optional<BottleEffect> deserialize(String type, String effectId, CompoundTag tag) {
        return !REGISTRY.containsKey(type) ? Optional.empty() : Optional.of(REGISTRY.get(type).apply(effectId, tag));
    }
}

