/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CooldownReductionBottleEffect
extends BottleEffect {
    public static final String TYPE = "cooldown_reduction";
    private final float amount;

    public CooldownReductionBottleEffect(String effectId, float amount) {
        super(effectId);
        this.amount = amount;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void trigger(ServerPlayer player) {
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get((ServerLevel)player.f_19853_);
        AbilityTree abilityTree = abilitiesData.getAbilities((Player)player);
        abilityTree.iterate(Ability.class, ability -> ability.getCooldown().ifPresent(cooldown -> ability.reduceCooldownBy((int)((float)cooldown.getMaxTicks() * this.amount))));
        abilityTree.sync(SkillContext.of(player));
    }

    @Override
    public CompoundTag serializeData(CompoundTag tag) {
        tag.m_128350_("amount", this.amount);
        return tag;
    }

    @Override
    public String getTooltipText(String tooltipFormat) {
        return String.format(tooltipFormat, (int)(100.0f * this.amount));
    }

    public static BottleEffect deserialize(String effectId, CompoundTag tag) {
        return new CooldownReductionBottleEffect(effectId, tag.m_128457_("amount"));
    }
}

