/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal;

import iskallia.vault.core.IVersion;
import iskallia.vault.item.crystal.CrystalData;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public enum CrystalVersion implements IVersion<CrystalVersion>
{
    LEGACY(CrystalVersion::convertLegacyTo1),
    v1(CrystalVersion::convert1to2),
    v2(CrystalVersion::convert2to3);

    private final Consumer<CompoundTag> fixer;

    private CrystalVersion(Consumer<CompoundTag> fixer) {
        this.fixer = fixer;
    }

    @Override
    public CrystalVersion getThis() {
        return this;
    }

    public CrystalVersion next() {
        return this == CrystalVersion.latest() ? this : CrystalVersion.values()[this.ordinal() + 1];
    }

    public static CrystalVersion latest() {
        return CrystalVersion.values()[CrystalVersion.values().length - 1];
    }

    public static CrystalVersion oldest() {
        return CrystalVersion.values()[0];
    }

    static CompoundTag upgrade(CompoundTag nbt) {
        for (CrystalVersion version = CrystalData.VERSION.readNbt(nbt.m_128423_("Version")).orElse(LEGACY); version != CrystalVersion.latest(); version = version.next()) {
            version.fixer.accept(nbt);
        }
        return nbt;
    }

    static void convertLegacyTo1(CompoundTag nbt) {
        nbt.m_128405_("Version", v1.ordinal());
        int instabilityCounter = nbt.m_128451_("instabilityCounter");
        float instability = instabilityCounter <= 3 ? 0.0f : Math.min((float)(instabilityCounter - 3) * 0.05f, 0.9f);
        nbt.m_128350_("Instability", nbt.m_128457_("Instability") + instability);
        nbt.m_128379_("Exhausted", !nbt.m_128471_("canBeModified"));
        CompoundTag modifiers = new CompoundTag();
        modifiers.m_128365_("List", (Tag)nbt.m_128437_("Modifiers", 10));
        modifiers.m_128379_("RandomModifiers", !nbt.m_128471_("preventsRandomModifiers"));
        modifiers.m_128379_("Clarity", nbt.m_128471_("clarity"));
        nbt.m_128365_("Modifiers", (Tag)modifiers);
    }

    static void convert1to2(CompoundTag nbt) {
        CompoundTag modifiers;
        nbt.m_128405_("Version", v2.ordinal());
        if (nbt.m_128425_("Modifiers", 10) && !(modifiers = nbt.m_128469_("Modifiers")).m_128425_("type", 8)) {
            modifiers.m_128359_("type", "default");
        }
    }

    private static void convert2to3(CompoundTag tag) {
    }
}

