/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class FrameData
implements INBTSerializable<CompoundTag> {
    public List<Tile> tiles = new ArrayList<Tile>();

    public static FrameData fromNBT(CompoundTag nbt) {
        FrameData frame = new FrameData();
        frame.deserializeNBT(nbt);
        return frame;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag tilesList = new ListTag();
        this.tiles.forEach(tile -> tilesList.add((Object)tile.serializeNBT()));
        nbt.m_128365_("Tiles", (Tag)tilesList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tilesList = nbt.m_128437_("Tiles", 10);
        this.tiles.clear();
        for (int i = 0; i < tilesList.size(); ++i) {
            Tile tile = new Tile();
            tile.deserializeNBT(tilesList.m_128728_(i));
            this.tiles.add(tile);
        }
    }

    public static class Tile
    implements INBTSerializable<CompoundTag> {
        public Block block;
        public CompoundTag data;
        public BlockPos pos;

        public Tile() {
        }

        public Tile(Block block, CompoundTag data, BlockPos pos) {
            this.block = block;
            this.data = data;
            this.pos = pos;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Block", this.block.getRegistryName().toString());
            nbt.m_128365_("Data", (Tag)this.data.m_6426_());
            nbt.m_128405_("PosX", this.pos.m_123341_());
            nbt.m_128405_("PosY", this.pos.m_123342_());
            nbt.m_128405_("PosZ", this.pos.m_123343_());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("Block")));
            this.data = nbt.m_128469_("Data").m_6426_();
            this.pos = new BlockPos(nbt.m_128451_("PosX"), nbt.m_128451_("PosY"), nbt.m_128451_("PosZ"));
        }
    }
}

