/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.data.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonSerializationContext;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.IAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;

public interface IComplexAdapter<T, N extends Tag, J extends JsonElement, C>
extends IAdapter<T, N, J, C> {
    default public void writeBits(@Nullable T value, BitBuffer buffer) {
        this.writeBits(value, buffer, null);
    }

    default public Optional<T> readBits(BitBuffer buffer) {
        return this.readBits(buffer, null);
    }

    default public void writeBytes(@Nullable T value, ByteBuf buffer) {
        this.writeBytes(value, buffer, null);
    }

    default public Optional<T> readBytes(ByteBuf buffer) {
        return this.readBytes(buffer, null);
    }

    default public void writeData(@Nullable T value, DataOutput data) throws IOException {
        this.writeData(value, data, null);
    }

    default public Optional<T> readData(DataInput data) throws IOException {
        return this.readData(data, null);
    }

    default public Optional<N> writeNbt(@Nullable T value) {
        return this.writeNbt(value, null);
    }

    default public Optional<T> readNbt(@Nullable N nbt) {
        return this.readNbt(nbt, null);
    }

    default public Optional<J> writeJson(@Nullable T value) {
        return this.writeJson(value, null);
    }

    default public Optional<T> readJson(@Nullable J json) {
        return this.readJson(json, null);
    }

    @Override
    public void writeBits(@Nullable T var1, BitBuffer var2, @Nullable C var3);

    @Override
    public Optional<T> readBits(BitBuffer var1, @Nullable C var2);

    @Override
    public void writeBytes(@Nullable T var1, ByteBuf var2, @Nullable C var3);

    @Override
    public Optional<T> readBytes(ByteBuf var1, @Nullable C var2);

    @Override
    public void writeData(@Nullable T var1, DataOutput var2, @Nullable C var3) throws IOException;

    @Override
    public Optional<T> readData(DataInput var1, @Nullable C var2) throws IOException;

    @Override
    public Optional<N> writeNbt(@Nullable T var1, @Nullable C var2);

    @Override
    public Optional<T> readNbt(@Nullable N var1, @Nullable C var2);

    @Override
    public Optional<J> writeJson(@Nullable T var1, @Nullable C var2);

    @Override
    public Optional<T> readJson(@Nullable J var1, @Nullable C var2);

    @Override
    default public JsonElement serialize(T value, Type source, JsonSerializationContext context) {
        return this.writeJson(value).map(json -> json).orElse((JsonElement)JsonNull.INSTANCE);
    }

    @Override
    default public T deserialize(JsonElement json, Type source, JsonDeserializationContext context) {
        return this.readJson(json).orElse(null);
    }
}

