/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ClassicCircleLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class ClassicCircleCrystalLayout
extends ClassicInfiniteCrystalLayout {
    protected int radius;

    public ClassicCircleCrystalLayout() {
    }

    public ClassicCircleCrystalLayout(int tunnelSpan, int radius) {
        super(tunnelSpan);
        this.radius = radius;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        vault.getOptional(Vault.WORLD).map(world -> world.get(WorldManager.GENERATOR)).ifPresent(generator -> {
            if (generator instanceof GridGenerator) {
                GridGenerator grid = (GridGenerator)generator;
                grid.set(GridGenerator.LAYOUT, new ClassicCircleLayout(this.tunnelSpan, this.radius));
            }
        });
    }

    @Override
    public void addText(List<Component> tooltip, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Circle").m_130940_(ChatFormatting.GREEN)));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            nbt.m_128405_("radius", this.radius);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = nbt.m_128451_("radius");
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            json.addProperty("radius", (Number)this.radius);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = json.get("radius").getAsInt();
    }
}

