/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ClassicPolygonLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class ClassicPolygonCrystalLayout
extends ClassicInfiniteCrystalLayout {
    protected int[] vertices;

    public ClassicPolygonCrystalLayout() {
    }

    public ClassicPolygonCrystalLayout(int tunnelSpan, int[] vertices) {
        super(tunnelSpan);
        this.vertices = vertices;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        vault.getOptional(Vault.WORLD).map(world -> world.get(WorldManager.GENERATOR)).ifPresent(generator -> {
            if (generator instanceof GridGenerator) {
                GridGenerator grid = (GridGenerator)generator;
                grid.set(GridGenerator.LAYOUT, new ClassicPolygonLayout(this.tunnelSpan, this.vertices));
            }
        });
    }

    @Override
    public void addText(List<Component> tooltip, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Polygon").m_130940_(ChatFormatting.GOLD)));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            ListTag list = new ListTag();
            for (int i = 0; i < this.vertices.length; i += 2) {
                CompoundTag element = new CompoundTag();
                element.m_128405_("x", this.vertices[i]);
                element.m_128405_("z", this.vertices[i + 1]);
                list.add((Object)element);
            }
            nbt.m_128365_("vertices", (Tag)list);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        ListTag list = nbt.m_128437_("vertices", 10);
        this.vertices = new int[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag element = list.m_128728_(i);
            this.vertices[i * 2] = element.m_128451_("x");
            this.vertices[i * 2 + 1] = element.m_128451_("z");
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            JsonArray list = new JsonArray();
            for (int i = 0; i < this.vertices.length; i += 2) {
                JsonObject element = new JsonObject();
                element.addProperty("x", (Number)this.vertices[i]);
                element.addProperty("z", (Number)this.vertices[i + 1]);
                list.add((JsonElement)element);
            }
            json.add("vertices", (JsonElement)list);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        JsonArray list = json.get("vertices").getAsJsonArray();
        this.vertices = new int[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            JsonObject element = list.get(i).getAsJsonObject();
            this.vertices[i * 2] = element.get("x").getAsInt();
            this.vertices[i * 2 + 1] = element.get("z").getAsInt();
        }
    }
}

