/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ClassicPresetLayout;
import iskallia.vault.core.world.template.data.DirectTemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.preset.ParadoxTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.PoolTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.StructurePreset;
import iskallia.vault.world.data.ParadoxCrystalData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ParadoxCrystalLayout
extends ClassicInfiniteCrystalLayout {
    private UUID playerUuid;

    public ParadoxCrystalLayout() {
        super(1);
    }

    public void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    public StructurePreset getPreset() {
        StructurePreset preset = null;
        if (this.playerUuid != null) {
            preset = ParadoxCrystalData.getEntry((UUID)this.playerUuid).preset;
        }
        if (preset == null) {
            preset = new StructurePreset().put(RegionPos.ORIGIN, new PoolTemplatePreset((TemplatePool)new TemplatePool().addLeaf(new DirectTemplateEntry(VaultMod.id("vault/starts/personal_vault_start1"), Arrays.asList(VaultMod.id("generic/gate_placeholder"), VaultMod.id("gate_lock/base"))), 1.0)));
        }
        return preset;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        if (!vault.has(Vault.WORLD)) {
            return;
        }
        vault.get(Vault.WORLD).ifPresent(WorldManager.GENERATOR, generator -> {
            if (!(generator instanceof GridGenerator)) {
                return;
            }
            GridGenerator grid = (GridGenerator)generator;
            grid.set(GridGenerator.LAYOUT, new ClassicPresetLayout(this.tunnelSpan, this.getPreset()));
        });
    }

    @Override
    public void addText(List<Component> tooltip, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Preset").m_130948_(Style.f_131099_.m_178520_(0xD3D3D3))));
        HashMap godCounts = new HashMap();
        this.getPreset().getAll().forEach((regionPos, preset) -> {
            ParadoxTemplatePreset paradoxTemplatePreset;
            VaultGod god;
            if (preset instanceof ParadoxTemplatePreset && (god = (paradoxTemplatePreset = (ParadoxTemplatePreset)preset).getGod()) != null) {
                godCounts.put(god, godCounts.getOrDefault((Object)god, 0) + 1);
            }
        });
        for (VaultGod god : VaultGod.values()) {
            int count = godCounts.getOrDefault((Object)god, 0);
            String roomStr = count == 1 ? "Room" : "Rooms";
            MutableComponent txt = new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(this.playerUuid == null ? "?" : String.valueOf(count)).m_130940_(ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)new TextComponent(god.getName()).m_130940_(god.getChatColor())).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        }
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.playerUuid = player.m_36316_().getId();
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UUID.writeNbt(this.playerUuid).ifPresent(uuid -> nbt.m_128365_("player_uuid", uuid));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.playerUuid = Adapters.UUID.readNbt(nbt.m_128423_("player_uuid")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.UUID.writeJson(this.playerUuid).ifPresent(uuid -> json.add("player_uuid", uuid));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.playerUuid = Adapters.UUID.readJson(json.get("player_uuid")).orElse(null);
    }
}

