/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout.preset;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.item.crystal.data.serializable.ISerializable;
import iskallia.vault.item.crystal.layout.preset.TemplatePreset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class StructurePreset
implements ISerializable<CompoundTag, JsonObject> {
    private Map<RegionPos, TemplatePreset> rooms = new HashMap<RegionPos, TemplatePreset>();

    public Optional<TemplatePreset> get(RegionPos region) {
        return Optional.ofNullable(this.rooms.get((Object)region));
    }

    public boolean contains(RegionPos region) {
        return this.rooms.containsKey((Object)region);
    }

    public StructurePreset put(RegionPos region, TemplatePreset entry) {
        this.rooms.put(region, entry);
        return this;
    }

    public Map<RegionPos, TemplatePreset> getAll() {
        return this.rooms;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_7.writeBits(this.rooms.size(), buffer);
        this.rooms.forEach((region, entry) -> {
            Adapters.INT_SEGMENTED_3.writeBits(region.m_123341_(), buffer);
            Adapters.INT_SEGMENTED_3.writeBits(region.m_123343_(), buffer);
            Adapters.TEMPLATE_PRESET.writeBits((TemplatePreset)entry, buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        int groupSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.rooms = new HashMap<RegionPos, TemplatePreset>();
        for (int i = 0; i < groupSize; ++i) {
            int x = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            int z = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            RegionPos region = RegionPos.of(x, z, 0, 0);
            TemplatePreset entry = (TemplatePreset)Adapters.TEMPLATE_PRESET.readBits(buffer).orElseThrow();
            this.rooms.put(region, entry);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag rooms = new ListTag();
        this.rooms.forEach((region, entry) -> {
            CompoundTag element = new CompoundTag();
            ListTag list = new ListTag();
            list.add((Object)IntTag.m_128679_((int)region.m_123341_()));
            list.add((Object)IntTag.m_128679_((int)region.m_123343_()));
            element.m_128365_("region", (Tag)list);
            Adapters.TEMPLATE_PRESET.writeNbt((TemplatePreset)entry).ifPresent(value -> {
                element.m_128365_("entry", value);
                rooms.add((Object)element);
            });
        });
        nbt.m_128365_("rooms", (Tag)rooms);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.rooms = new HashMap<RegionPos, TemplatePreset>();
        ListTag rooms = nbt.m_128437_("rooms", 10);
        for (int i = 0; i < rooms.size(); ++i) {
            CompoundTag element = rooms.m_128728_(i);
            ListTag list = element.m_128437_("region", 3);
            int x = list.m_128763_(0);
            int z = list.m_128763_(1);
            RegionPos region = RegionPos.of(x, z, 0, 0);
            TemplatePreset entry = (TemplatePreset)Adapters.TEMPLATE_PRESET.readNbt(element.m_128423_("entry")).orElseThrow();
            this.rooms.put(region, entry);
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray rooms = new JsonArray();
        this.rooms.forEach((region, entry) -> {
            JsonObject element = new JsonObject();
            JsonArray list = new JsonArray();
            list.add((Number)region.m_123341_());
            list.add((Number)region.m_123343_());
            element.add("region", (JsonElement)list);
            Adapters.TEMPLATE_PRESET.writeJson((TemplatePreset)entry).ifPresent(value -> {
                element.add("entry", value);
                rooms.add((JsonElement)element);
            });
        });
        json.add("rooms", (JsonElement)rooms);
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.rooms = new HashMap<RegionPos, TemplatePreset>();
        JsonArray rooms = json.getAsJsonArray("rooms");
        for (int i = 0; i < rooms.size(); ++i) {
            JsonObject element = rooms.get(i).getAsJsonObject();
            JsonArray list = element.getAsJsonArray("region");
            int x = list.get(0).getAsInt();
            int z = list.get(1).getAsInt();
            RegionPos region = RegionPos.of(x, z, 0, 0);
            TemplatePreset entry = (TemplatePreset)Adapters.TEMPLATE_PRESET.readJson(element.get("entry")).orElseThrow();
            this.rooms.put(region, entry);
        }
    }
}

