/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.modifiers;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import iskallia.vault.world.data.ParadoxCrystalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ParadoxCrystalModifiers
extends CrystalModifiers {
    private UUID playerUuid;

    public void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    @Override
    public List<VaultModifierStack> getList() {
        return this.playerUuid == null ? new ArrayList() : ParadoxCrystalData.getEntry((UUID)this.playerUuid).modifiers;
    }

    @Override
    public boolean hasRandomModifiers() {
        return false;
    }

    @Override
    public boolean hasClarity() {
        return true;
    }

    @Override
    public void setRandomModifiers(boolean randomModifiers) {
    }

    @Override
    public void setClarity(boolean clarity) {
    }

    @Override
    public boolean addByCrafting(CrystalData crystal, List<VaultModifierStack> modifierStackList, CrystalData.Simulate simulate) {
        return false;
    }

    @Override
    public boolean addByCrafting(CrystalData crystal, VaultModifierStack modifierStack, boolean preventsRandomModifiers, CrystalData.Simulate simulate) {
        return false;
    }

    @Override
    public void add(VaultModifierStack modifierStack) {
        super.add(modifierStack);
        ParadoxCrystalData.getEntry((UUID)this.playerUuid).changed = true;
    }

    @Override
    public void addText(List<Component> tooltip, TooltipFlag flag, float time) {
        Style style = Style.f_131099_.m_131148_(ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.curseColor);
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(stack.getModifierId()), (Component)new TextComponent("Cursed").m_130948_(style), tooltip);
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isGood(stack.getModifierId()), (Component)new TextComponent("Positive Modifiers").m_130940_(ChatFormatting.GREEN), tooltip);
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isBad(stack.getModifierId()), (Component)new TextComponent("Negative Modifiers").m_130940_(ChatFormatting.RED), tooltip);
        this.addNonCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isUnlisted(stack.getModifierId()), (Component)new TextComponent("Other Modifiers").m_130940_(ChatFormatting.WHITE), tooltip);
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.playerUuid = player.m_36316_().getId();
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UUID.writeNbt(this.playerUuid).ifPresent(uuid -> nbt.m_128365_("player_uuid", uuid));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.playerUuid = Adapters.UUID.readNbt(nbt.m_128423_("player_uuid")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.UUID.writeJson(this.playerUuid).ifPresent(uuid -> json.add("player_uuid", uuid));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.playerUuid = Adapters.UUID.readJson(json.get("player_uuid")).orElse(null);
    }
}

