/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.CrystalProperty;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.objective.NullCrystalObjective;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class CompoundCrystalObjective
extends CrystalObjective {
    protected List<CrystalObjective> children;

    public CompoundCrystalObjective() {
        this.children = new ArrayList<CrystalObjective>();
    }

    public CompoundCrystalObjective(List<CrystalObjective> children) {
        this.children = children;
    }

    @Override
    public Collection<CrystalProperty> getChildren() {
        return this.children.stream().map(child -> child).toList();
    }

    @Override
    public Optional<Integer> getColor(float time) {
        for (CrystalObjective child : this.children) {
            Optional<Integer> color = child.getColor(time);
            if (!color.isPresent()) continue;
            return color;
        }
        return Optional.empty();
    }

    public static CompoundCrystalObjective flatten(CrystalObjective ... objectives) {
        ArrayList<CrystalObjective> children = new ArrayList<CrystalObjective>();
        for (CrystalObjective objective : objectives) {
            if (objective instanceof CompoundCrystalObjective) {
                children.addAll(((CompoundCrystalObjective)objective).children);
                continue;
            }
            if (objective == null) continue;
            children.add(objective);
        }
        return new CompoundCrystalObjective(children);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (CrystalObjective child : this.children) {
            if (child == NullCrystalObjective.INSTANCE) {
                CompoundTag element = new CompoundTag();
                element.m_128359_("type", "null");
                list.add((Object)element);
                continue;
            }
            CrystalData.OBJECTIVE.writeNbt(child).ifPresent(arg_0 -> list.add(arg_0));
        }
        nbt.m_128365_("children", (Tag)list);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.children = new ArrayList<CrystalObjective>();
        ListTag list = nbt.m_128437_("children", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag element = list.m_128728_(i);
            if (element.m_128441_("type") && element.m_128461_("type").equals("null")) {
                this.children.add(NullCrystalObjective.INSTANCE);
                continue;
            }
            this.children.add((CrystalObjective)CrystalData.OBJECTIVE.readNbt((Tag)element).orElseThrow());
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        for (CrystalObjective child : this.children) {
            if (child == NullCrystalObjective.INSTANCE) {
                JsonObject element = new JsonObject();
                element.addProperty("type", "null");
                array.add((JsonElement)element);
                continue;
            }
            CrystalData.OBJECTIVE.writeJson(child).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0));
        }
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.children = new ArrayList<CrystalObjective>();
        JsonArray array = json.getAsJsonArray("children");
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (element.has("type") && element.get("type").getAsString().equals("null")) {
                this.children.add(NullCrystalObjective.INSTANCE);
                continue;
            }
            this.children.add((CrystalObjective)CrystalData.OBJECTIVE.readJson((JsonElement)element).orElseThrow());
        }
    }
}

