/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.data;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.ArchitectCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.time.ValueCrystalTime;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.MysticExpertise;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class InscriptionData
implements INBTSerializable<CompoundTag> {
    public static final String NBT_KEY = "data";
    public static final int MODELS = 16;
    private VListNBT<Entry, CompoundTag> entries = VListNBT.of(Entry::new);
    private float completion;
    private int time;
    private float instability;
    private int model;
    private Integer color;

    private InscriptionData() {
    }

    public static InscriptionData empty() {
        return new InscriptionData();
    }

    public static InscriptionData from(ItemStack stack) {
        InscriptionData data = new InscriptionData();
        if (stack.m_41782_()) {
            data.deserializeNBT(stack.m_41784_().m_128469_(NBT_KEY));
        }
        return data;
    }

    public InscriptionData write(ItemStack stack) {
        stack.m_41784_().m_128365_(NBT_KEY, (Tag)this.serializeNBT());
        return this;
    }

    public int getModel() {
        return this.model;
    }

    public Integer getColor() {
        return this.color;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public InscriptionData add(ResourceLocation pool, int count, int color) {
        this.entries.add(new Entry(pool, null, count, color));
        return this;
    }

    public InscriptionData add(ArchitectRoomEntry.Type type, int count, int color) {
        this.entries.add(new Entry(null, type, count, color));
        return this;
    }

    public InscriptionData add(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    public void setCompletion(float completion) {
        this.completion = completion;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setInstability(float instability) {
        this.instability = instability;
    }

    public void setModel(int model) {
        this.model = model;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    public boolean apply(Player player, ItemStack stack, CrystalData crystal) {
        Object entry2;
        if (crystal.isUnmodifiable()) {
            return false;
        }
        CrystalLayout crystalLayout = crystal.getLayout();
        if (!(crystalLayout instanceof ArchitectCrystalLayout)) {
            return false;
        }
        ArchitectCrystalLayout layout = (ArchitectCrystalLayout)crystalLayout;
        for (Object entry2 : this.entries) {
            layout.add(entry2.toRoomEntry());
        }
        layout.addCompletion(this.completion);
        entry2 = crystal.getTime();
        if (entry2 instanceof ValueCrystalTime) {
            ValueCrystalTime data = (ValueCrystalTime)entry2;
            IntRoll intRoll = data.getRoll();
            if (intRoll instanceof IntRoll.Constant) {
                IntRoll.Constant constant = (IntRoll.Constant)intRoll;
                crystal.setTime(new ValueCrystalTime(IntRoll.ofConstant(constant.getCount() + this.time)));
            } else {
                intRoll = data.getRoll();
                if (intRoll instanceof IntRoll.Uniform) {
                    IntRoll.Uniform uniform = (IntRoll.Uniform)intRoll;
                    crystal.setTime(new ValueCrystalTime(IntRoll.ofUniform(uniform.getMin() + this.time, uniform.getMax() + this.time)));
                }
            }
        }
        float instability = crystal.getInstability();
        Random random = new Random();
        if (random.nextFloat() < instability) {
            double instabilityAvoidanceChance = 0.0;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                instabilityAvoidanceChance = PlayerExpertisesData.get(serverPlayer.m_183503_()).getExpertises((Player)serverPlayer).getAll(MysticExpertise.class, Skill::isUnlocked).stream().mapToDouble(MysticExpertise::getInstabilityChanceReduction).sum();
            }
            if (random.nextDouble() > instabilityAvoidanceChance) {
                if (random.nextFloat() < ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.exhaustProbability) {
                    VaultCrystalItem.scheduleTask(VaultCrystalItem.ExhaustTask.INSTANCE, stack);
                } else {
                    VaultCrystalItem.scheduleTask(new VaultCrystalItem.AddModifiersTask(VaultMod.id("catalyst_curse")), stack);
                }
            }
        }
        crystal.setInstability(crystal.getInstability() + this.instability);
        crystal.write(stack);
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag entriesList = new ListTag();
        for (Entry entry : this.entries) {
            entriesList.add((Object)entry.serializeNBT());
        }
        nbt.m_128365_("entries", (Tag)entriesList);
        nbt.m_128350_("completion", this.completion);
        nbt.m_128405_("time", this.time);
        nbt.m_128350_("instability", this.instability);
        nbt.m_128405_("model", this.model);
        if (this.color != null) {
            nbt.m_128405_("color", this.color.intValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag entriesList = nbt.m_128437_("entries", 10);
        this.entries.clear();
        for (int i = 0; i < entriesList.size(); ++i) {
            Entry entry = new Entry();
            entry.deserializeNBT(entriesList.m_128728_(i));
            this.entries.add(entry);
        }
        this.completion = nbt.m_128457_("completion");
        this.time = nbt.m_128451_("time");
        this.instability = nbt.m_128457_("instability");
        this.model = nbt.m_128451_("model");
        if (nbt.m_128425_("color", 3)) {
            this.color = nbt.m_128451_("color");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TextComponent("Completion: ").m_7220_((Component)new TextComponent(Math.round(this.completion * 100.0f) + "%").m_130948_(Style.f_131099_.m_178520_(4766456))));
        tooltip.add((Component)new TextComponent("Time: ").m_7220_((Component)new TextComponent(UIHelper.formatTimeString(this.time)).m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("Instability: ").m_7220_((Component)new TextComponent("%.1f%%".formatted(Float.valueOf(this.instability * 100.0f))).m_130940_(ChatFormatting.RED)));
        for (Entry entry : this.entries) {
            String roomStr = entry.count > 1 ? "Rooms" : "Room";
            MutableComponent txt = new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(entry.count)).m_130940_(ChatFormatting.GRAY)).m_130946_(" ").m_7220_(entry.toRoomEntry().getName()).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        }
    }

    public static class Entry
    implements INBTSerializable<CompoundTag> {
        @Expose
        private ResourceLocation pool;
        @Expose
        private ArchitectRoomEntry.Type type;
        @Expose
        public int count;
        @Expose
        public int color;

        public Entry() {
        }

        public Entry(ResourceLocation pool, ArchitectRoomEntry.Type type, int count, int color) {
            this.pool = pool;
            this.type = type;
            this.count = count;
            this.color = color;
        }

        public ArchitectRoomEntry toRoomEntry() {
            if (this.pool != null) {
                return (ArchitectRoomEntry)ArchitectRoomEntry.ofPool(this.pool, this.count).set(ArchitectRoomEntry.COLOR, this.color);
            }
            return (ArchitectRoomEntry)ArchitectRoomEntry.ofType(this.type, this.count).set(ArchitectRoomEntry.COLOR, this.color);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.pool != null) {
                nbt.m_128359_("pool", this.pool.toString());
            }
            if (this.type != null) {
                nbt.m_128405_("type", this.type.ordinal());
            }
            nbt.m_128405_("count", this.count);
            nbt.m_128405_("color", this.color);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (nbt.m_128441_("pool")) {
                this.pool = new ResourceLocation(nbt.m_128461_("pool"));
            }
            if (nbt.m_128441_("type")) {
                this.type = ArchitectRoomEntry.Type.values()[nbt.m_128451_("type")];
            }
            this.count = nbt.m_128451_("count");
            this.color = nbt.m_128451_("color");
        }
    }
}

