/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import iskallia.vault.config.EtchingConfig;
import iskallia.vault.etching.EtchingRegistry;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.VHSmpUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtchingItem
extends BasicItem
implements DataTransferItem,
IdentifiableItem {
    public EtchingItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    public static ItemStack createEtchingStack(EtchingSet<?> etchingSet) {
        ItemStack etchingStack = new ItemStack((ItemLike)ModItems.ETCHING);
        Object data = AttributeGearData.read(etchingStack);
        ((AttributeGearData)data).updateAttribute(ModGearAttributes.ETCHING, etchingSet);
        ((AttributeGearData)data).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        ((AttributeGearData)data).write(etchingStack);
        return etchingStack;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        super.m_6787_(tab, items);
        if (!ModConfigs.isInitialized()) {
            return;
        }
        if (this.m_41389_(tab)) {
            EtchingRegistry.getOrderedEntries().stream().map(EtchingItem::createEtchingStack).forEach(arg_0 -> items.add(arg_0));
        }
    }

    public Component m_7626_(ItemStack stack) {
        TranslatableComponent name = new TranslatableComponent(this.m_5671_(stack));
        ((AttributeGearData)((Object)AttributeGearData.read(stack))).getFirstValue(ModGearAttributes.ETCHING).ifPresent(arg_0 -> EtchingItem.lambda$getName$0((MutableComponent)name, arg_0));
        return name;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!VHSmpUtil.isArenaWorld(world) && this.tryStartIdentification(player, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (world instanceof ServerLevel && stack.m_41613_() > 1) {
                while (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    ItemStack etching = stack.m_41777_();
                    etching.m_41764_(1);
                    MiscUtils.giveItem(player, etching);
                }
            }
            this.inventoryIdentificationTick((Player)player, stack);
        }
    }

    @Override
    public void tickRoll(ItemStack stack, Player player) {
        EtchingSet<?> data = AttributeGearData.read(stack);
        EtchingSet<?> etchingSet = ModConfigs.ETCHING.getRandomEtchingSet();
        if (etchingSet != null) {
            ((AttributeGearData)((Object)data)).updateAttribute(ModGearAttributes.ETCHING, etchingSet);
        }
        ((AttributeGearData)((Object)data)).write(stack);
    }

    @Override
    public void tickFinishRoll(ItemStack stack, Player player) {
        Object data = AttributeGearData.read(stack);
        Optional<EtchingSet<?>> optEtchingSet = ((AttributeGearData)data).getFirstValue(ModGearAttributes.ETCHING);
        if (optEtchingSet.isPresent()) {
            ((AttributeGearData)data).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        } else {
            ((AttributeGearData)data).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.UNIDENTIFIED);
        }
        ((AttributeGearData)data).write(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Object data = AttributeGearData.read(stack);
        if (((AttributeGearData)data).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED) {
            ((AttributeGearData)data).getFirstValue(ModGearAttributes.ETCHING).ifPresent(etchingSet -> {
                EtchingConfig.Etching config = ModConfigs.ETCHING.getEtchingConfig((EtchingSet<?>)((Object)etchingSet));
                if (config != null) {
                    tooltip.add((Component)new TextComponent("Etching: ").m_130946_(config.getName()).m_130948_(Style.f_131099_.m_131148_(config.getComponentColor())));
                    tooltip.add(TextComponent.f_131282_);
                    for (TextComponent cmp : MiscUtils.splitDescriptionText(config.getEffectText())) {
                        tooltip.add((Component)cmp.m_130940_(ChatFormatting.GRAY));
                    }
                }
            });
        }
    }

    private static /* synthetic */ void lambda$getName$0(MutableComponent name, EtchingSet etchingSet) {
        EtchingConfig.Etching config = ModConfigs.ETCHING.getEtchingConfig(etchingSet);
        if (config != null) {
            name.m_6270_(name.m_7383_().m_131148_(config.getComponentColor()));
        }
    }
}

