/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.modification;

import iskallia.vault.config.gear.VaultGearTagConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.IdolItem;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.item.modification.GearModificationItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReforgeTagModificationFocus
extends GearModificationItem
implements DataTransferItem {
    private static final Map<Item, String> ITEM_TO_NAME = new HashMap<Item, String>();

    public ReforgeTagModificationFocus(ResourceLocation id, GearModification modification) {
        super(id, modification);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!ModConfigs.isInitialized()) {
            return;
        }
        if (this.m_41389_(tab)) {
            for (String tag : ModConfigs.VAULT_GEAR_TAG_CONFIG.getTags()) {
                ItemStack focus = new ItemStack((ItemLike)this);
                ReforgeTagModificationFocus.setModifierTag(focus, tag);
                items.add((Object)focus);
            }
        }
    }

    @Override
    public ItemStack convertStack(ItemStack stack, RandomSource random) {
        String randomTag;
        ItemStack result = DataTransferItem.super.convertStack(stack, random);
        if (ReforgeTagModificationFocus.getModifierTag(result) == null && (randomTag = ModConfigs.VAULT_GEAR_TAG_CONFIG.getRandomTag()) != null) {
            ReforgeTagModificationFocus.setModifierTag(result, randomTag);
        }
        return result;
    }

    @Nullable
    public static VaultGearTagConfig.ModTagGroup getModifierTag(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ReforgeTagModificationFocus)) {
            return null;
        }
        String tagStr = stack.m_41784_().m_128461_("modTag");
        return ModConfigs.VAULT_GEAR_TAG_CONFIG.getGroupTag(tagStr);
    }

    public static void setModifierTag(ItemStack stack, String tag) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ReforgeTagModificationFocus)) {
            return;
        }
        stack.m_41784_().m_128359_("modTag", tag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        if (!Screen.m_96638_()) {
            return;
        }
        VaultGearTagConfig.ModTagGroup group = ReforgeTagModificationFocus.getModifierTag(stack);
        if (group == null) {
            return;
        }
        ReforgeTagModificationFocus.getAttributes(group).forEach((attribute, items) -> {
            VaultGearModifierReader reader = attribute.getReader();
            MutableComponent text = new TextComponent(" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(reader.getModifierName()).m_130948_(reader.getColoredTextStyle()));
            if (Screen.m_96639_()) {
                text.m_7220_((Component)new TextComponent(" (" + ReforgeTagModificationFocus.getItemsDisplay(items) + ")").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)text);
        });
    }

    private static Map<VaultGearAttribute<?>, List<Item>> getAttributes(VaultGearTagConfig.ModTagGroup tagGroup) {
        LinkedHashMap attributes = new LinkedHashMap();
        ModConfigs.VAULT_GEAR_CONFIG.forEach((item, config) -> tagGroup.getTags().forEach(tag -> config.getModifierConfigurationsByTag((String)tag).forEach(tpl -> {
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getAttribute());
            attributes.computeIfAbsent(attribute, a -> new ArrayList()).add(item);
        })));
        return attributes;
    }

    private static String getItemsDisplay(List<Item> items) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<VaultArmorItem> armors = new ArrayList<VaultArmorItem>();
        if (items.contains(ModItems.HELMET)) {
            armors.add(ModItems.HELMET);
        }
        if (items.contains(ModItems.CHESTPLATE)) {
            armors.add(ModItems.CHESTPLATE);
        }
        if (items.contains(ModItems.LEGGINGS)) {
            armors.add(ModItems.LEGGINGS);
        }
        if (items.contains(ModItems.BOOTS)) {
            armors.add(ModItems.BOOTS);
        }
        if (armors.size() == 4) {
            lines.add("Armor");
        } else {
            armors.forEach(item -> lines.add(ITEM_TO_NAME.get(item)));
        }
        ArrayList<VaultGearItem> weapons = new ArrayList<VaultGearItem>();
        if (items.contains(ModItems.SWORD)) {
            weapons.add(ModItems.SWORD);
        }
        if (items.contains(ModItems.AXE)) {
            weapons.add(ModItems.AXE);
        }
        if (weapons.size() == 2) {
            lines.add("Weapon");
        } else {
            weapons.forEach(item -> lines.add(ITEM_TO_NAME.get(item)));
        }
        if (items.contains(ModItems.SHIELD)) {
            lines.add("Shield");
        }
        if (items.contains(ModItems.MAGNET)) {
            lines.add("Magnet");
        }
        ArrayList<IdolItem> idols = new ArrayList<IdolItem>();
        if (items.contains(ModItems.IDOL_BENEVOLENT)) {
            idols.add(ModItems.IDOL_BENEVOLENT);
        }
        if (items.contains(ModItems.IDOL_OMNISCIENT)) {
            idols.add(ModItems.IDOL_OMNISCIENT);
        }
        if (items.contains(ModItems.IDOL_TIMEKEEPER)) {
            idols.add(ModItems.IDOL_TIMEKEEPER);
        }
        if (items.contains(ModItems.IDOL_MALEVOLENCE)) {
            idols.add(ModItems.IDOL_MALEVOLENCE);
        }
        if (idols.size() == 4) {
            lines.add("Idol");
        } else {
            idols.forEach(item -> lines.add(ITEM_TO_NAME.get(item)));
        }
        StringBuilder result = new StringBuilder();
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            result.append(line);
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    static {
        ITEM_TO_NAME.put((Item)ModItems.HELMET, "Helmet");
        ITEM_TO_NAME.put((Item)ModItems.CHESTPLATE, "Chestplate");
        ITEM_TO_NAME.put((Item)ModItems.LEGGINGS, "Leggings");
        ITEM_TO_NAME.put((Item)ModItems.BOOTS, "Boots");
        ITEM_TO_NAME.put((Item)ModItems.SWORD, "Sword");
        ITEM_TO_NAME.put((Item)ModItems.AXE, "Axe");
        ITEM_TO_NAME.put((Item)ModItems.SHIELD, "Shield");
        ITEM_TO_NAME.put(ModItems.IDOL_BENEVOLENT, "Velara Idol");
        ITEM_TO_NAME.put(ModItems.IDOL_OMNISCIENT, "Tenos Idol");
        ITEM_TO_NAME.put(ModItems.IDOL_TIMEKEEPER, "Wendarr Idol");
        ITEM_TO_NAME.put(ModItems.IDOL_MALEVOLENCE, "Idona Idol");
    }
}

