/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.tool.ColorBlender;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JewelItem
extends Item
implements VaultGearItem,
DataInitializationItem,
DataTransferItem {
    public JewelItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public Component m_7626_(@NotNull ItemStack stack) {
        int color = JewelItem.getColor(stack);
        GearDataCache cache = GearDataCache.of(stack);
        VaultGearRarity rarity = (VaultGearRarity)((Object)ObjectUtils.firstNonNull((Object[])new VaultGearRarity[]{cache.getRarity(), VaultGearRarity.SCRAPPY}));
        if (rarity == VaultGearRarity.SCRAPPY) {
            return super.m_7626_(stack).m_6881_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
        }
        String prefix = this.m_5524_() + "." + rarity.name().toLowerCase(Locale.ROOT);
        return new TranslatableComponent(prefix).m_7220_(super.m_7626_(stack)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    @Override
    public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
    }

    @Override
    public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
    }

    @Override
    public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    @Override
    public void addTooltipCraftingPotential(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.vaultGearTick(stack, player);
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (category != ModItems.GEAR_GROUP) {
            return;
        }
        ArrayList<ItemStack> jewels = new ArrayList<ItemStack>();
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.PICKING, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.AXING, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.SHOVELLING, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.WOODEN_AFFINITY, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.ORNATE_AFFINITY, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.GILDED_AFFINITY, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.LIVING_AFFINITY, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.COIN_AFFINITY, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.SMELTING, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.PULVERIZING, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.HYDROVOID, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.SOULBOUND, true))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(0.1f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(1.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(10.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(100.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 1))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 10))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 100))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 1000))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 10000))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(0.001f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(0.01f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(0.1f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(1.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(0.001f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(0.01f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(0.1f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(1.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(0.001f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(0.01f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(0.1f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(1.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(0.001f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(0.01f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(0.1f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(1.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(0.001f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(0.01f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(0.1f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(1.0f)))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Double>(ModGearAttributes.REACH, 0.01))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Double>(ModGearAttributes.REACH, 0.1))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Double>(ModGearAttributes.REACH, 1.0))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 1))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 5))));
        jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 10))));
        for (ItemStack jewel : jewels) {
            VaultGearData data2 = VaultGearData.read(jewel);
            data2.setRarity(VaultGearRarity.UNIQUE);
            data2.setState(VaultGearState.IDENTIFIED);
            data2.write(jewel);
        }
        items.addAll(jewels);
    }

    @Override
    public void initialize(ItemStack stack, RandomSource random) {
        Random rand = ((JavaRandom)random).asRandomView();
        VaultGearData data = VaultGearData.read(stack);
        VaultGearRarity rarity = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(rollTypeStr -> ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool((String)rollTypeStr)).orElse(ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll()).getRandom(rand);
        data.setState(VaultGearState.IDENTIFIED);
        data.setRarity(rarity);
        data.write(stack);
        GearRollHelper.initializeGear(stack);
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getJewelRecyclingOutput();
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        return 1.0f;
    }

    @Override
    @Nonnull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.JEWEL;
    }

    @Override
    @Nonnull
    public ProficiencyType getCraftingProficiencyType(ItemStack stack) {
        return ProficiencyType.UNKNOWN;
    }

    @Override
    @Nullable
    public EquipmentSlot getIntendedSlot(ItemStack stack) {
        return null;
    }

    @Override
    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random) {
        return null;
    }

    public static int getColor(ItemStack stack) {
        GearDataCache clientCache = GearDataCache.of(stack);
        ColorBlender blender = new ColorBlender(1.0f);
        Optional.ofNullable(clientCache.getJewelColorComponents()).ifPresent(colors -> colors.forEach(color -> blender.add((int)color, 60.0f)));
        float time = ClientScheduler.INSTANCE.getTickCount();
        return blender.getColor(time);
    }

    public static ItemStack create(Consumer<VaultGearData> consumer) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.JEWEL);
        VaultGearData data = VaultGearData.read(stack);
        consumer.accept(data);
        data.write(stack);
        return stack;
    }
}

