/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.loot.LootTable;
import iskallia.vault.core.world.loot.entry.ItemLootEntry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.tool.JewelItem;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class Pulverizing {
    public static void handle(List<ItemStack> loot) {
        for (int i = loot.size() - 1; i >= 0; --i) {
            ItemStack raw = loot.get(i);
            LootTable table = ModConfigs.TOOL_PULVERIZING.get(raw.m_41720_());
            if (table == null) continue;
            loot.remove(i);
            LootTableGenerator generator = new LootTableGenerator(Version.latest(), table, 0.0f);
            generator.generate(JavaRandom.ofNanoTime());
            generator.getItems().forEachRemaining(pulverized -> {
                pulverized.m_41764_(raw.m_41613_() * pulverized.m_41613_());
                loot.add((ItemStack)pulverized);
            });
        }
    }

    public static void register(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new Category(registration.getJeiHelpers().getGuiHelper())});
    }

    public static void register(IRecipeRegistration registration) {
        registration.addRecipes(Category.RECIPE_TYPE, ModConfigs.TOOL_PULVERIZING.getLoot().entrySet().stream().flatMap(entry -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)entry.getKey());
            if (item == null || item == Items.f_41852_) {
                return Stream.empty();
            }
            return Stream.of(new Recipe(new ItemStack((ItemLike)item), new LootTable((List)entry.getValue())));
        }).toList());
    }

    public static void register(IRecipeCatalystRegistration registration) {
        ItemStack tool = new ItemStack((ItemLike)ModItems.TOOL);
        VaultGearData data = VaultGearData.read(tool);
        data.setState(VaultGearState.IDENTIFIED);
        data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.PULVERIZING, true));
        data.write(tool);
        registration.addRecipeCatalyst(tool, new RecipeType[]{Category.RECIPE_TYPE});
    }

    private static class Category
    implements IRecipeCategory<Recipe> {
        public static final RecipeType<Recipe> RECIPE_TYPE = RecipeType.create((String)"the_vault", (String)"pulverizing", Recipe.class);
        private static final ResourceLocation TEXTURE = VaultMod.id("textures/gui/vault_recycler_jei.png");
        private final IDrawable background;
        private final IDrawable icon;

        public Category(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(TEXTURE, 33, 30, 104, 26);
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.PREFIX, new VaultGearModifier<Boolean>(ModGearAttributes.PULVERIZING, true))));
        }

        @Nonnull
        public Component getTitle() {
            return new TextComponent("Pulverizing");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        @Nonnull
        public IDrawable getIcon() {
            return this.icon;
        }

        @ParametersAreNonnullByDefault
        public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStack(recipe.getInput());
            for (LootTable.Entry entry : recipe.getOutput().getEntries()) {
                WeightedList entries = new WeightedList();
                entry.getPool().getChildren().forEach((loot, weight) -> {
                    if (!(loot instanceof ItemLootEntry)) {
                        return;
                    }
                    entries.put((ItemLootEntry)loot, (Double)weight);
                });
                int index = 0;
                for (Map.Entry e : entries.entrySet()) {
                    ItemLootEntry item = (ItemLootEntry)e.getKey();
                    double weight2 = e.getValue();
                    ItemStack min = new ItemStack((ItemLike)item.getItem());
                    ItemStack max = new ItemStack((ItemLike)item.getItem());
                    min.m_41764_(IntRoll.getMin(item.getCount()));
                    max.m_41764_(IntRoll.getMax(item.getCount()));
                    if (item.getNbt() != null) {
                        min.m_41751_(item.getNbt().m_6426_());
                        max.m_41751_(item.getNbt().m_6426_());
                    }
                    int probability = (int)Math.round(weight2 / entries.getTotalWeight() * 100.0);
                    min.m_41714_((Component)min.m_41786_().m_6881_().m_7220_((Component)new TextComponent(" (%d%%)".formatted(probability))));
                    max.m_41714_((Component)max.m_41786_().m_6881_().m_7220_((Component)new TextComponent(" (%d%%)".formatted(probability))));
                    builder.addSlot(RecipeIngredientRole.OUTPUT, 49 + index++ * 18, 5).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{min, max}));
                }
            }
        }

        @Nonnull
        public RecipeType<Recipe> getRecipeType() {
            return RECIPE_TYPE;
        }

        @Nonnull
        public ResourceLocation getUid() {
            return this.getRecipeType().getUid();
        }

        @Nonnull
        public Class<? extends Recipe> getRecipeClass() {
            return this.getRecipeType().getRecipeClass();
        }
    }

    private static class Recipe {
        private final ItemStack input;
        private final LootTable output;

        public Recipe(ItemStack input, LootTable output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public LootTable getOutput() {
            return this.output;
        }
    }
}

