/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class SpecialItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public SpecialItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void renderModel(ModelResourceLocation location, int tint, ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrices, MultiBufferSource buffer, int light, int overlay, Boolean foil) {
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
        if (transformType == ItemTransforms.TransformType.GUI && !model.m_7547_()) {
            Lighting.m_84930_();
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        model = ForgeHooksClient.handleCameraTransforms((PoseStack)matrices, (BakedModel)model, (ItemTransforms.TransformType)transformType, (transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND ? 1 : 0) != 0);
        matrices.m_85837_(-0.5, -0.5, -0.5);
        if (model.isLayered()) {
            for (Pair layerModel : model.getLayerModels(stack, true)) {
                BakedModel layer = (BakedModel)layerModel.getFirst();
                RenderType renderType = (RenderType)layerModel.getSecond();
                ForgeHooksClient.setRenderType((RenderType)renderType);
                VertexConsumer consumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)(foil == null ? stack.m_41790_() : foil.booleanValue()));
                Minecraft.m_91087_().m_91291_().m_115189_(layer, stack, light, overlay, matrices, consumer);
                if (!(buffer instanceof MultiBufferSource.BufferSource)) continue;
                MultiBufferSource.BufferSource src = (MultiBufferSource.BufferSource)buffer;
                src.m_109912_(renderType);
            }
            ForgeHooksClient.setRenderType(null);
        } else {
            RenderType renderType = ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true);
            VertexConsumer consumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)(foil == null ? stack.m_41790_() : foil.booleanValue()));
            this.renderModelLists(model, tint, matrices, consumer, light, overlay);
            if (buffer instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource src = (MultiBufferSource.BufferSource)buffer;
                src.m_109912_(renderType);
            }
        }
        if (transformType == ItemTransforms.TransformType.GUI && !model.m_7547_()) {
            Lighting.m_84931_();
        }
        matrices.m_85849_();
    }

    public void renderModelLists(BakedModel model, int tint, PoseStack matrices, VertexConsumer buffer, int light, int overlay) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            this.renderQuadList(model.m_6840_(null, direction, random), tint, matrices, buffer, light, overlay);
        }
        this.renderQuadList(model.m_6840_(null, null, random), tint, matrices, buffer, light, overlay);
    }

    public void renderQuadList(List<BakedQuad> quads, int tint, PoseStack matrices, VertexConsumer buffer, int light, int overlay) {
        PoseStack.Pose matrix = matrices.m_85850_();
        for (BakedQuad quad : quads) {
            float red = (float)(tint >> 16 & 0xFF) / 255.0f;
            float green = (float)(tint >> 8 & 0xFF) / 255.0f;
            float blue = (float)(tint & 0xFF) / 255.0f;
            buffer.putBulkData(matrix, quad, red, green, blue, light, overlay, true);
        }
    }
}

