/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.tool.SpecialItemRenderer;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ToolItemRenderer
extends SpecialItemRenderer {
    public static final ToolItemRenderer INSTANCE = new ToolItemRenderer();

    public void m_108829_(@NotNull ItemStack stack, @NotNull ItemTransforms.TransformType transformType, @NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, int light, int overlay) {
        @Nullable ToolType type = ToolType.of(stack);
        VaultGearData data = VaultGearData.read(stack);
        ToolMaterial material = data.get(ModGearAttributes.TOOL_MATERIAL, VaultGearAttributeTypeMerger.of(() -> null, (a, b) -> b));
        if (material == null) {
            int total = type == null ? 16 * ToolType.values().length : 16;
            material = ToolMaterial.values()[(int)(ClientScheduler.INSTANCE.getTickCount() / (long)total) % ToolMaterial.values().length];
        }
        if (type == null) {
            type = ToolType.values()[(int)(ClientScheduler.INSTANCE.getTickCount() >> 4) % ToolType.values().length];
        }
        ModelResourceLocation head = new ModelResourceLocation("the_vault:tool/%s/head/%s#inventory".formatted(type.getId(), material.getId()));
        ModelResourceLocation handle = new ModelResourceLocation("the_vault:tool/%s/handle#inventory".formatted(type.getId()));
        this.renderModel(handle, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
        this.renderModel(head, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        atlas.apply(new ResourceLocation(head.m_135827_(), "item/" + head.m_135815_()));
    }
}

