/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.event.ClientEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Final
    @Shadow
    private Minecraft f_109059_;

    @Inject(method={"bobHurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurtByDurationNoBobDamage(PoseStack pMatrixStack, float pPartialTicks, CallbackInfo ci) {
        if (((IVaultOptions)this.f_109059_.f_91066_).doVanillaPotionDamageEffects()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)((GameRenderer)this).m_172797_().m_91288_();
        if (livingEntity == null || livingEntity.m_21224_() || livingEntity != this.f_109059_.f_91074_ || this.isNotCorrectDamageSourceOrDoesntHaveEffect(livingEntity)) {
            return;
        }
        ci.cancel();
    }

    private boolean isNotCorrectDamageSourceOrDoesntHaveEffect(LivingEntity livingEntity) {
        return !this.isNoBobDamageSource(livingEntity.m_21225_()) && (!this.isApplicablePotionDamageSource(livingEntity.m_21225_()) || !this.hasApplicableEffect(livingEntity));
    }

    private boolean isNoBobDamageSource(DamageSource damageSource) {
        return damageSource == DamageSource.f_19307_;
    }

    private boolean isApplicablePotionDamageSource(DamageSource damageSource) {
        return damageSource == DamageSource.f_19319_ || damageSource == DamageSource.f_19320_;
    }

    private boolean hasApplicableEffect(LivingEntity livingEntity) {
        for (MobEffectInstance activeEffect : livingEntity.m_21220_()) {
            if (activeEffect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL || activeEffect.f_19503_ <= 0) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/ForgeHooksClient;dispatchRenderLast(Lnet/minecraft/client/renderer/LevelRenderer;Lcom/mojang/blaze3d/vertex/PoseStack;FLcom/mojang/math/Matrix4f;J)V")})
    private void doRenderLevelLastEvent(float pTicks, long nanoTime, PoseStack poseStack, CallbackInfo ci) {
        ClientEvents.RENDER_LEVEL_LAST.invoke(pTicks, nanoTime, poseStack);
    }
}

