/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.VaultMod;
import iskallia.vault.config.DurabilityConfig;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.IConditionalDamageable;
import iskallia.vault.util.calc.DurabilityWearReductionHelper;
import iskallia.vault.world.data.ServerVaults;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=1001)
public abstract class MixinItemStack {
    @Shadow
    @Final
    @Deprecated
    private Item f_41589_;
    private float health;

    @Shadow
    public abstract int m_41776_();

    @Shadow
    public abstract ItemStack m_41777_();

    @Shadow
    public abstract Item m_41720_();

    @Shadow
    public abstract boolean m_41763_();

    @Shadow
    public abstract int m_41773_();

    @Shadow
    public abstract void m_41721_(int var1);

    @Shadow
    public abstract void m_41663_(Enchantment var1, int var2);

    @Overwrite
    public boolean m_41629_(int damage, Random rand, @Nullable ServerPlayer damager) {
        VaultGearItem gearItem;
        if (!this.m_41763_()) {
            return false;
        }
        if (this.f_41589_ == Items.f_42741_ && new Random().nextInt(5) != 0) {
            return false;
        }
        Item item = this.m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken((ItemStack)this)) {
            return false;
        }
        if (damage > 0) {
            IConditionalDamageable cd;
            item = this.m_41720_();
            if (item instanceof IConditionalDamageable && (cd = (IConditionalDamageable)item).isImmuneToDamage((ItemStack)this, (Player)damager)) {
                return false;
            }
            int unbreaking = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)((ItemStack)this));
            int durabilityNegation = 0;
            boolean isArmor = ((ItemStack)this).m_41720_() instanceof ArmorItem;
            DurabilityConfig cfg = ModConfigs.DURABILITY;
            float chance = isArmor ? cfg.getArmorDurabilityIgnoreChance(unbreaking) : cfg.getDurabilityIgnoreChance(unbreaking);
            for (int k = 0; unbreaking > 0 && k < damage; ++k) {
                if (!(rand.nextFloat() < chance)) continue;
                ++durabilityNegation;
            }
            int wearReduction = 0;
            if (damager != null) {
                float wearReductionChance = DurabilityWearReductionHelper.getDurabilityWearReduction((LivingEntity)damager);
                for (int k = 0; k < damage; ++k) {
                    if (!(rand.nextFloat() < wearReductionChance)) continue;
                    ++wearReduction;
                }
            }
            damage -= durabilityNegation;
            if ((damage -= wearReduction) <= 0) {
                return false;
            }
        }
        if (damager != null && damage != 0) {
            CriteriaTriggers.f_10586_.m_43669_(damager, (ItemStack)this, this.m_41773_() + damage);
        }
        int absDamage = this.m_41773_() + damage;
        this.m_41721_(absDamage);
        int newDamage = this.m_41773_();
        if (damager != null && newDamage == -1) {
            damager.f_19853_.m_5594_(null, damager.m_20097_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return newDamage >= this.m_41776_();
    }

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    public void useGearRarity(CallbackInfoReturnable<Component> ci) {
        if (!(this.m_41720_() instanceof VaultGearItem)) {
            return;
        }
        ItemStack itemStack = this.m_41777_();
        VaultGearData data = VaultGearData.read(itemStack);
        VaultGearState state = data.getState();
        if (state == VaultGearState.UNIDENTIFIED) {
            return;
        }
        MutableComponent returnValue = (MutableComponent)ci.getReturnValue();
        Style style = returnValue.m_7383_().m_131148_(data.getRarity().getColor());
        ci.setReturnValue((Object)returnValue.m_6270_(style));
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isDamaged()Z"))
    public boolean alwaysShowDamageTooltip(ItemStack stack) {
        VaultGearData data;
        if (stack.m_41720_() instanceof VaultGearItem && (data = VaultGearData.read(stack)).getState() == VaultGearState.IDENTIFIED) {
            return true;
        }
        return stack.m_41768_();
    }

    @Inject(method={"getHoverName"}, at={@At(value="HEAD")}, cancellable=true)
    public void getGearHoverName(CallbackInfoReturnable<Component> cir) {
        CompoundTag compoundtag;
        ItemStack thisInstance = (ItemStack)this;
        if (thisInstance.m_41720_() instanceof VaultGearItem && (compoundtag = thisInstance.m_41737_("display")) != null && compoundtag.m_128425_("Name", 8)) {
            try {
                MutableComponent component = Component.Serializer.m_130701_((String)compoundtag.m_128461_("Name"));
                if (component != null) {
                    VaultGearData gearData = VaultGearData.read(thisInstance);
                    cir.setReturnValue((Object)component.m_130948_(Style.f_131099_.m_131148_(gearData.getRarity().getColor())));
                    return;
                }
                compoundtag.m_128473_("Name");
            }
            catch (Exception exception) {
                compoundtag.m_128473_("Name");
            }
        }
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")})
    public void finishUsingItemHead(Level world, LivingEntity entity, CallbackInfoReturnable<ItemStack> ci) {
        this.health = entity.m_21223_();
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="RETURN")})
    public void finishUsingItemReturn(Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> ci) {
        Player player;
        VirtualWorld world;
        block3: {
            block2: {
                if (!(level instanceof VirtualWorld)) break block2;
                world = (VirtualWorld)level;
                if (entity instanceof Player && !((player = (Player)entity).m_21223_() <= this.health) && this.m_41720_() != ModItems.BOTTLE) break block3;
            }
            return;
        }
        ServerVaults.get((Level)world).ifPresent(vault -> vault.ifPresent(Vault.MODIFIERS, modifiers -> {
            int present = (int)modifiers.getEntries().stream().map(Modifiers.Entry::getContext).map(ModifierContext::getGroup).filter(Optional::isPresent).map(Optional::get).filter(id -> id.equals((Object)VaultMod.id("healing_penalty"))).count();
            if (present < 4) {
                ChunkRandom random = ChunkRandom.any();
                random.setSeed(vault.get(Vault.SEED));
                random.setRegionSeed(vault.get(Vault.SEED), present, -present, random.nextInt() * present);
                MixinItemStack.addModifier(world, vault, player, VaultMod.id("healing_penalty"), random);
            }
        }));
    }

    private static void addModifier(VirtualWorld world, Vault vault, Player player, ResourceLocation pool, RandomSource random) {
        ArrayList modifiers = new ArrayList(ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, vault.get(Vault.LEVEL).get(), random));
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> MixinItemStack.lambda$addModifier$3((Object2IntMap)groups, arg_0));
        ObjectIterator it = groups.object2IntEntrySet().iterator();
        TextComponent suffix = new TextComponent("");
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            suffix.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it.hasNext()) continue;
            suffix.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent text = new TextComponent("");
        if (modifiers.isEmpty()) {
            text.m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" angered the ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("gods").m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        } else {
            text.m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" angered the ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("gods").m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent(" and added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        }
        groups.forEach((modifier, count) -> vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)modifier, (int)count, true, random, context -> context.setGroup(pool)));
        for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
            listener.getPlayer().ifPresent(other -> {
                world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), ModSounds.MOB_TRAP, SoundSource.PLAYERS, 0.9f, 0.6f);
                other.m_5661_((Component)text, false);
            });
        }
    }

    private static /* synthetic */ void lambda$addModifier$3(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }
}

