/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.modifier.modifier.EntityEffectModifier;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.entity.entity.FighterEntity;
import iskallia.vault.entity.entity.VaultGuardianEntity;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.WingsTrinket;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.calc.ResistanceHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements ChampionLogic.IChampionLogicHolder,
EntityEffectModifier.ILivingEntityAccessor {
    private float prevSize = -1.0f;
    @Nullable
    private ChampionLogic championLogic = new ChampionLogic();
    private Map<MobEffectInstance, Double> scheduledEffects = new HashMap<MobEffectInstance, Double>();
    @Shadow
    protected ItemStack f_20935_;
    @Shadow
    public long f_20930_;
    @Shadow
    protected int f_20937_;
    @Shadow
    @Final
    private AttributeMap f_20943_;
    private float rawHealth;
    private boolean useRawHealth;

    @Override
    public ChampionLogic getChampionLogic() {
        return this.championLogic;
    }

    public MixinLivingEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public Map<MobEffectInstance, Double> getEffects() {
        return this.scheduledEffects;
    }

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract AttributeInstance m_21051_(Attribute var1);

    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    @Shadow
    public abstract boolean m_6117_();

    @Shadow
    public abstract int m_21212_();

    @Shadow
    public abstract float m_21233_();

    @Shadow
    public abstract float m_21223_();

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    protected abstract void m_6472_(DamageSource var1, float var2);

    @Shadow
    public abstract double m_21133_(Attribute var1);

    @Shadow
    public abstract AttributeMap m_21204_();

    @Redirect(method={"createLivingAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;builder()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"))
    private static AttributeSupplier.Builder registerAttributes() {
        return AttributeSupplier.m_22244_().m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22278_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22284_).m_22266_(Attributes.f_22285_).m_22266_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22266_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).m_22266_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22266_(ModAttributes.CRIT_CHANCE).m_22266_(ModAttributes.CRIT_MULTIPLIER).m_22266_(ModAttributes.TP_CHANCE).m_22266_(ModAttributes.TP_INDIRECT_CHANCE).m_22266_(ModAttributes.TP_RANGE).m_22266_(ModAttributes.POTION_RESISTANCE).m_22266_(ModAttributes.SIZE_SCALE).m_22266_(ModAttributes.BREAK_ARMOR_CHANCE).m_22266_(ModAttributes.MANA_MAX).m_22266_(ModAttributes.MANA_REGEN).m_22266_(ModAttributes.REACH).m_22266_(ModAttributes.CROSSBOW_CHARGE_TIME).m_22266_(ModAttributes.THORNS_CHANCE).m_22266_(ModAttributes.THORNS_DAMAGE);
    }

    @Inject(method={"getAttributeValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void getAttributeValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        if (attribute == ForgeMod.REACH_DISTANCE.get()) {
            if (this.f_19853_.m_5776_() && ClientVaults.getActive().isPresent()) {
                cir.setReturnValue((Object)Math.min(this.m_21204_().m_22181_(attribute), 7.0));
            } else if (ServerVaults.get(this.f_19853_).isPresent()) {
                cir.setReturnValue((Object)Math.min(this.m_21204_().m_22181_(attribute), 7.0));
            }
        }
    }

    @Redirect(method={"die"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasCustomName()Z"))
    public boolean removeFighterKilledLogMessage(LivingEntity entity) {
        if (entity instanceof FighterEntity) {
            return false;
        }
        return entity.m_8077_();
    }

    @Inject(method={"getTicksUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTicksUsingItem(CallbackInfoReturnable<Integer> ci) {
        AttributeInstance attribute;
        if (this.f_20935_.m_41720_() == Items.f_42717_ && this.m_6117_() && (attribute = this.m_21051_(ModAttributes.CROSSBOW_CHARGE_TIME)) != null && attribute.m_22135_() > 0.0) {
            int value = this.f_20935_.m_41779_() - this.m_21212_();
            ci.setReturnValue((Object)((int)((double)this.f_20935_.m_41779_() / attribute.m_22135_() * (double)value)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void exitIfDamageAlreadyHandled(byte pId, CallbackInfo ci) {
        if (pId == 2 && this.f_20930_ == this.f_19853_.m_46467_() && !((IVaultOptions)Minecraft.m_91087_().f_91066_).doVanillaPotionDamageEffects()) {
            ci.cancel();
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    public void applyResistance(DamageSource pSource, float pDamage, CallbackInfoReturnable<Float> cir) {
        float resistance;
        LivingEntity entity = (LivingEntity)this;
        if (AttributeSnapshotHelper.canHaveSnapshot(entity) && (double)(resistance = ResistanceHelper.getResistance(entity)) > 1.0E-4) {
            float damage = ((Float)cir.getReturnValue()).floatValue();
            cir.setReturnValue((Object)Float.valueOf(Math.max(damage - damage * resistance, 0.0f)));
        }
    }

    @Redirect(method={"getDamageAfterArmorAbsorb"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtArmor(Lnet/minecraft/world/damagesource/DamageSource;F)V"))
    public void preventHurtArmor(LivingEntity entity, DamageSource src, float damage) {
        if (src.m_7639_() instanceof VaultGuardianEntity) {
            return;
        }
        this.m_6472_(src, damage);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        AttributeInstance scale;
        if (this.useRawHealth && this.rawHealth > 0.0f && this.rawHealth > this.m_21223_()) {
            this.m_21153_(this.rawHealth);
            this.useRawHealth = false;
        }
        if ((scale = this.m_21051_(ModAttributes.SIZE_SCALE)) == null) {
            return;
        }
        if ((double)this.prevSize != scale.m_22135_()) {
            this.prevSize = (float)scale.m_22135_();
            this.f_19815_ = this.m_6972_(Pose.STANDING).m_20388_(this.prevSize);
            this.m_6210_();
        }
        this.championLogic.tick(this);
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void addPotionEffect(MobEffectInstance effect, CallbackInfoReturnable<Boolean> ci) {
        AttributeInstance attribute = this.m_21051_(ModAttributes.POTION_RESISTANCE);
        if (attribute == null) {
            return;
        }
        if (this.f_19796_.nextDouble() >= attribute.m_22135_()) {
            return;
        }
        ci.setReturnValue((Object)false);
    }

    @Redirect(method={"collectEquipmentChanges"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    private Multimap<Attribute, AttributeModifier> preventVanillaAttributes(ItemStack stack, EquipmentSlot slot) {
        LivingEntity entity = (LivingEntity)this;
        if (stack.m_41720_() instanceof VaultGearItem && entity instanceof Player) {
            Player player = (Player)entity;
            int playerLevel = SidedHelper.getVaultLevel(player);
            if (VaultGearData.read(stack).getItemLevel() > playerLevel) {
                return HashMultimap.create();
            }
        }
        return stack.m_41638_(slot);
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        if (ServerVaults.get(this.f_19853_).isPresent()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/LivingEntity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        this.championLogic.serialize().ifPresent(championNbt -> nbt.m_128365_("championLogic", (Tag)championNbt));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (!nbt.m_128425_("Health", 99)) {
            return;
        }
        float health = nbt.m_128457_("Health");
        if (health > this.m_21233_() && health > 0.0f) {
            this.rawHealth = health;
            this.useRawHealth = true;
        }
        if (nbt.m_128425_("championLogic", 10)) {
            this.championLogic = ChampionLogic.deserialize(nbt.m_128469_("championLogic"));
        }
        if (nbt.m_128425_("Modifiers", 10)) {
            CompoundTag modifiers = nbt.m_128469_("Modifiers");
            for (String key : modifiers.m_128431_()) {
                Registry.f_122866_.m_6612_(ResourceLocation.m_135820_((String)key)).ifPresent(attribute -> {
                    AttributeInstance instance = this.m_21051_((Attribute)attribute);
                    if (instance == null) {
                        return;
                    }
                    CompoundTag entry = modifiers.m_128469_(key);
                    double amount = entry.m_128459_("Value");
                    AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)entry.m_128451_("Operation"));
                    instance.m_22125_(new AttributeModifier(UUID.randomUUID(), "Unspecified", amount, operation));
                });
            }
        }
    }

    @Inject(method={"updateFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFlag(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        AtomicBoolean flag = new AtomicBoolean(this.m_20291_(7));
        if (flag.get() && !this.f_19861_ && !this.m_20159_() && !this.m_21023_(MobEffects.f_19620_)) {
            ItemStack itemstack = livingEntity.m_6844_(EquipmentSlot.CHEST);
            flag.set(itemstack.canElytraFly(livingEntity) && itemstack.elytraFlightTick(livingEntity, this.f_20937_));
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                TrinketHelper.getTrinkets((LivingEntity)player, WingsTrinket.class).forEach(wings -> {
                    if (!wings.isUsable(player)) {
                        return;
                    }
                    flag.set(true);
                });
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20115_(7, flag.get());
        }
        ci.cancel();
    }
}

