/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.util.ColorOption;
import iskallia.vault.util.CooldownGuiOption;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Options.class})
public class MixinOptions
implements IVaultOptions {
    public CooldownGuiOption cooldownGuiOption = CooldownGuiOption.OFF;
    public boolean doVanillaPotionDamageEffects = false;
    public boolean hunterCustomColorsEnabled = false;
    public boolean abilityScrollingEnabled = true;
    public boolean showPointMessages = true;
    public boolean showRarityNames = false;
    public ColorOption chestHunterSpec = new ColorOption(ColorOption.HunterSpec.BASE, 0.8901961f, 0.5529412f, 0.0f);
    public ColorOption blockHunterSpec = new ColorOption(ColorOption.HunterSpec.OBSERVER, 0.14509805f, 0.6745098f, 0.0f);
    public ColorOption gildedHunterSpec = new ColorOption(ColorOption.HunterSpec.GILDED, 1.0f, 1.0f, 0.0f);
    public ColorOption livingHunterSpec = new ColorOption(ColorOption.HunterSpec.LIVING, 0.0f, 1.0f, 0.0f);
    public ColorOption ornateHunterSpec = new ColorOption(ColorOption.HunterSpec.ORNATE, 0.93333334f, 0.0f, 0.0f);
    public ColorOption coinsHunterSpec = new ColorOption(ColorOption.HunterSpec.COINS, 0.8039216f, 0.44705883f, 0.15294118f);

    @Inject(method={"processOptions"}, at={@At(value="HEAD")})
    private void processVaultOptions(Options.FieldAccess pAccessor, CallbackInfo ci) {
        this.doVanillaPotionDamageEffects = pAccessor.m_142682_("doVanillaPotionDamageEffects", this.doVanillaPotionDamageEffects);
        this.hunterCustomColorsEnabled = pAccessor.m_142682_("hunter_CustomColorsEnabled", this.hunterCustomColorsEnabled);
        this.abilityScrollingEnabled = pAccessor.m_142682_("abilityScrollingEnabled", this.abilityScrollingEnabled);
        this.showPointMessages = pAccessor.m_142682_("showPointMessages", this.showPointMessages);
        this.showRarityNames = pAccessor.m_142682_("showRarityNames", this.showRarityNames);
        this.cooldownGuiOption = (CooldownGuiOption)((Object)pAccessor.m_142634_(CooldownGuiOption.OFF.m_7912_(), (Object)this.cooldownGuiOption, CooldownGuiOption::fromString, CooldownGuiOption::m_7912_));
        this.chestHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.BASE.toString(), (Object)this.chestHunterSpec, this::readColorOption, this::writeColorOption);
        this.blockHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.OBSERVER.toString(), (Object)this.blockHunterSpec, this::readColorOption, this::writeColorOption);
        this.gildedHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.GILDED.toString(), (Object)this.gildedHunterSpec, this::readColorOption, this::writeColorOption);
        this.livingHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.LIVING.toString(), (Object)this.livingHunterSpec, this::readColorOption, this::writeColorOption);
        this.ornateHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.ORNATE.toString(), (Object)this.ornateHunterSpec, this::readColorOption, this::writeColorOption);
        this.coinsHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.COINS.toString(), (Object)this.coinsHunterSpec, this::readColorOption, this::writeColorOption);
    }

    private String writeColorOption(ColorOption t) {
        return String.format("%s,%s,%s,%s", t.getHunterSpec().name(), Float.valueOf(t.getRed()), Float.valueOf(t.getGreen()), Float.valueOf(t.getBlue()));
    }

    private ColorOption readColorOption(String string) {
        String[] split = string.split(",");
        return new ColorOption(split[0], Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
    }

    @Override
    public CooldownGuiOption getCooldownGuiOption() {
        return this.cooldownGuiOption;
    }

    @Override
    public void cycleCooldownGuiOption() {
        this.cooldownGuiOption = this.cooldownGuiOption.cycle();
    }

    @Override
    public boolean doVanillaPotionDamageEffects() {
        return this.doVanillaPotionDamageEffects;
    }

    @Override
    public void setVanillaPotionDamageEffects(boolean vanillaPotionDamageEffects) {
        this.doVanillaPotionDamageEffects = vanillaPotionDamageEffects;
    }

    @Override
    public boolean isHunterCustomColorsEnabled() {
        return this.hunterCustomColorsEnabled;
    }

    @Override
    public void setHunterCustomColorsEnabled(boolean hunterCustomColorsEnabled) {
        this.hunterCustomColorsEnabled = hunterCustomColorsEnabled;
    }

    @Override
    public boolean isAbilityScrollingEnabled() {
        return this.abilityScrollingEnabled;
    }

    @Override
    public void setAbilityScrollingEnabled(boolean abilityScrollingEnabled) {
        this.abilityScrollingEnabled = abilityScrollingEnabled;
    }

    @Override
    public boolean showPointMessages() {
        return this.showPointMessages;
    }

    @Override
    public void setShowPointMessages(boolean showPointMessages) {
        this.showPointMessages = showPointMessages;
    }

    @Override
    public boolean showRarityNames() {
        return this.showRarityNames;
    }

    @Override
    public void setShowRarityNames(boolean showRarityNames) {
        this.showRarityNames = showRarityNames;
    }

    @Override
    public ColorOption getChestHunterSpec() {
        return this.chestHunterSpec;
    }

    @Override
    public void setChestHunterSpec(ColorOption option) {
        this.chestHunterSpec = option;
    }

    @Override
    public ColorOption getBlockHunterSpec() {
        return this.blockHunterSpec;
    }

    @Override
    public void setBlockHunterSpec(ColorOption option) {
        this.blockHunterSpec = option;
    }

    @Override
    public ColorOption getGildedHunterSpec() {
        return this.gildedHunterSpec;
    }

    @Override
    public void setGildedHunterSpec(ColorOption option) {
        this.gildedHunterSpec = option;
    }

    @Override
    public ColorOption getLivingHunterSpec() {
        return this.livingHunterSpec;
    }

    @Override
    public void setLivingHunterSpec(ColorOption option) {
        this.livingHunterSpec = option;
    }

    @Override
    public ColorOption getOrnateHunterSpec() {
        return this.ornateHunterSpec;
    }

    @Override
    public void setOrnateHunterSpec(ColorOption option) {
        this.ornateHunterSpec = option;
    }

    @Override
    public ColorOption getCoinsHunterSpec() {
        return this.coinsHunterSpec;
    }

    @Override
    public void setCoinsHunterSpec(ColorOption option) {
        this.coinsHunterSpec = option;
    }

    @Override
    public ColorOption getBySpec(ColorOption.HunterSpec spec) {
        switch (spec) {
            case BASE: {
                return this.chestHunterSpec;
            }
            case OBSERVER: {
                return this.blockHunterSpec;
            }
            case GILDED: {
                return this.gildedHunterSpec;
            }
            case LIVING: {
                return this.livingHunterSpec;
            }
            case ORNATE: {
                return this.ornateHunterSpec;
            }
            case COINS: {
                return this.coinsHunterSpec;
            }
        }
        return this.chestHunterSpec;
    }

    @Override
    public ColorOption resetColorOption(ColorOption.HunterSpec spec) {
        switch (spec) {
            case BASE: {
                this.chestHunterSpec = new ColorOption(ColorOption.HunterSpec.BASE, 0.7607843f, 0.63529414f, 0.34901962f);
                return this.chestHunterSpec;
            }
            case OBSERVER: {
                this.blockHunterSpec = new ColorOption(ColorOption.HunterSpec.OBSERVER, 0.14509805f, 0.6745098f, 0.0f);
                return this.blockHunterSpec;
            }
            case GILDED: {
                this.gildedHunterSpec = new ColorOption(ColorOption.HunterSpec.GILDED, 1.0f, 1.0f, 0.0f);
                return this.gildedHunterSpec;
            }
            case LIVING: {
                this.livingHunterSpec = new ColorOption(ColorOption.HunterSpec.LIVING, 0.0f, 1.0f, 0.0f);
                return this.livingHunterSpec;
            }
            case ORNATE: {
                this.ornateHunterSpec = new ColorOption(ColorOption.HunterSpec.ORNATE, 0.93333334f, 0.0f, 0.0f);
                return this.ornateHunterSpec;
            }
            case COINS: {
                this.coinsHunterSpec = new ColorOption(ColorOption.HunterSpec.COINS, 0.8039216f, 0.44705883f, 0.15294118f);
                return this.coinsHunterSpec;
            }
        }
        return null;
    }

    @Override
    public void setColorOption(ColorOption.HunterSpec spec, ColorOption option) {
        switch (spec) {
            case BASE: {
                this.chestHunterSpec = option;
                break;
            }
            case OBSERVER: {
                this.blockHunterSpec = option;
                break;
            }
            case GILDED: {
                this.gildedHunterSpec = option;
                break;
            }
            case LIVING: {
                this.livingHunterSpec = option;
                break;
            }
            case ORNATE: {
                this.ornateHunterSpec = option;
                break;
            }
            case COINS: {
                this.coinsHunterSpec = option;
            }
        }
    }
}

