/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.entity.Targeting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.piglin.PiglinBruteAi;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinBruteAi.class})
public class MixinPiglinBruteAi {
    @Inject(method={"setAngerTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkAttackable(PiglinBrute piglinBrute, LivingEntity target, CallbackInfo ci) {
        if (Targeting.getTargetingResult((LivingEntity)piglinBrute, (Entity)target) == Targeting.TargetingResult.IGNORE) {
            ci.cancel();
        }
    }

    @Inject(method={"isNearestValidAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkTargetOverrides(AbstractPiglin piglin, LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Targeting.TargetingResult targetingResult = Targeting.getTargetingResult((LivingEntity)piglin, (Entity)entity);
        if (targetingResult != Targeting.TargetingResult.DEFAULT) {
            cir.setReturnValue((Object)targetingResult.getShouldTarget());
            cir.cancel();
        }
    }
}

