/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.container.inventory.ShardPouchContainer;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemShardPouch;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.InventorySnapshotData;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public abstract class MixinPlayerInventory
implements InventorySnapshotData.InventoryAccessor {
    @Shadow
    @Final
    public Player f_35978_;
    @Shadow
    @Final
    private List<NonNullList<ItemStack>> f_35979_;

    @Redirect(method={"hurtArmor"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"))
    public void hurtItemStack(ItemStack stack, int amount, LivingEntity entity, Consumer<LivingEntity> onBroken) {
        Player player;
        VaultGearItem gear;
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem && (gear = (VaultGearItem)item).isBroken(stack)) {
            return;
        }
        if (ServerVaults.get(this.f_35978_.f_19853_).isPresent()) {
            amount = Math.min(amount, 5);
        } else if (stack.m_41720_() instanceof VaultGearItem) {
            return;
        }
        if (this.f_35978_.m_20193_() instanceof ServerLevel) {
            amount = (int)CommonEvents.PLAYER_STAT.invoke(PlayerStat.DURABILITY_DAMAGE, (LivingEntity)this.f_35978_, amount).getValue();
        }
        stack.m_41622_(amount, entity, onBroken);
        item = stack.m_41720_();
        if (item instanceof VaultGearItem && (gear = (VaultGearItem)item).isBroken(stack) && (player = this.f_35978_) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AttributeSnapshotHelper.getInstance().refreshSnapshot(serverPlayer);
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptItemAddition(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.m_41720_() != ModItems.SOUL_SHARD) {
            return;
        }
        if (this.f_35978_.f_36096_ instanceof ShardPouchContainer) {
            return;
        }
        Inventory thisInventory = (Inventory)this;
        ItemStack pouchStack = ItemStack.f_41583_;
        for (int slot = 0; slot < thisInventory.m_6643_(); ++slot) {
            ItemStack invStack = thisInventory.m_8020_(slot);
            if (!(invStack.m_41720_() instanceof ItemShardPouch)) continue;
            pouchStack = invStack;
            break;
        }
        if (pouchStack.m_41619_()) {
            return;
        }
        pouchStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            ItemStack remainder = handler.insertItem(0, stack, false);
            stack.m_41764_(remainder.m_41613_());
            if (stack.m_41619_()) {
                cir.setReturnValue((Object)true);
            }
        });
    }

    @Override
    public int getSize() {
        return this.f_35979_.stream().mapToInt(NonNullList::size).sum();
    }
}

