/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.tool.HammerManager;
import iskallia.vault.item.tool.HammerTile;
import iskallia.vault.item.tool.IHammer;
import iskallia.vault.item.tool.ToolItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockBreakAckPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class MixinServerPlayerGameMode
implements IHammer {
    @Shadow
    @Final
    protected ServerPlayer f_9245_;
    @Shadow
    protected ServerLevel f_9244_;
    @Shadow
    private GameType f_9247_;
    @Shadow
    private int f_9252_;
    @Shadow
    private BlockPos f_9254_;
    @Shadow
    private int f_9250_;
    @Shadow
    private boolean f_9253_;
    @Shadow
    private BlockPos f_9251_;
    @Shadow
    private int f_9255_;
    private HammerManager hammer = new HammerManager();

    @Shadow
    public abstract boolean m_9295_();

    @Shadow
    public abstract void m_7712_();

    @Shadow
    public abstract void m_9286_(BlockPos var1, ServerboundPlayerActionPacket.Action var2, String var3);

    @Shadow
    public abstract boolean m_9280_(BlockPos var1);

    @Override
    public HammerManager getHammer() {
        return this.hammer;
    }

    @Redirect(method={"useItemOn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;doesSneakBypassUse(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)Z"))
    public boolean doesSneakBypassUse(ItemStack instance, LevelReader levelReader, BlockPos pos, Player player) {
        BlockState state = levelReader.m_8055_(pos);
        return state.m_60734_() instanceof VaultCrateBlock;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        this.hammer.tiles.removeIf(tile -> !tile.isDestroyingBlock);
        if (this.f_9253_) {
            BlockState blockstate = this.f_9244_.m_8055_(this.f_9254_);
            if (blockstate.m_60795_()) {
                return;
            }
            for (HammerTile tile2 : this.hammer.tiles) {
                BlockState state = this.f_9244_.m_8055_(tile2.destroyPos);
                float f = this.doDestroyProgress(state, tile2.destroyPos, this.f_9255_, tile2);
                if (!(f >= 1.0f)) continue;
                this.m_9280_(tile2.destroyPos);
            }
        }
        for (HammerTile tile3 : this.hammer.tiles) {
            if (!tile3.isDestroyingBlock) continue;
            BlockState blockstate = this.f_9244_.m_8055_(this.f_9251_);
            if (blockstate.m_60795_()) {
                this.f_9244_.m_6801_(-1, tile3.destroyPos, -1);
                tile3.lastSentState = -1;
                tile3.isDestroyingBlock = false;
                continue;
            }
            this.doDestroyProgress(this.f_9244_.m_8055_(tile3.destroyPos), tile3.destroyPos, tile3.destroyProgressStart, tile3);
        }
    }

    private float doDestroyProgress(BlockState state, BlockPos pos, int destroyProgressStart, HammerTile tile) {
        int i = this.f_9252_ - destroyProgressStart;
        float f = state.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, pos) * (float)(i + 1);
        int j = Math.min(9, (int)(f * 10.0f));
        if (j != tile.lastSentState) {
            this.f_9244_.m_6801_(-1, pos, j);
            tile.lastSentState = j;
        }
        return f;
    }

    @Inject(method={"handleBlockBreakAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;canInteractWith(Lnet/minecraft/core/BlockPos;D)Z", shift=At.Shift.BEFORE)})
    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction facing, int buildHeight, CallbackInfo ci) {
        if (!this.f_9245_.canInteractWith(pos, 1.0) || pos.m_123342_() >= buildHeight) {
            return;
        }
        if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.f_9244_.m_7966_((Player)this.f_9245_, pos)) {
                return;
            }
            if (this.m_9295_()) {
                if (this.hasHammer(this.f_9245_)) {
                    this.computeHammerTiles(pos, facing, buildHeight);
                }
                this.hammer.tiles.removeIf(tile -> {
                    this.m_9286_(tile.destroyPos, action, "creative destroy");
                    return true;
                });
                return;
            }
            if (this.f_9245_.m_36187_((Level)this.f_9244_, pos, this.f_9247_)) {
                return;
            }
            if (this.hasHammer(this.f_9245_)) {
                this.computeHammerTiles(pos, facing, buildHeight);
            }
            for (HammerTile tile2 : this.hammer.tiles) {
                tile2.destroyProgressStart = this.f_9252_;
                float f = 1.0f;
                BlockState blockstate = this.f_9244_.m_8055_(tile2.destroyPos);
                if (!blockstate.m_60795_()) {
                    blockstate.m_60686_((Level)this.f_9244_, tile2.destroyPos, (Player)this.f_9245_);
                    f = blockstate.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, tile2.destroyPos);
                }
                if (!blockstate.m_60795_() && f >= 1.0f) {
                    this.m_9286_(tile2.destroyPos, action, "insta mine");
                    continue;
                }
                if (tile2.isDestroyingBlock) {
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile2.destroyPos, this.f_9244_.m_8055_(tile2.destroyPos), ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, false, "abort destroying since another started (client insta mine, server disagreed)"));
                }
                tile2.isDestroyingBlock = true;
                int i = (int)(f * 10.0f);
                this.f_9244_.m_6801_(-1, tile2.destroyPos, i);
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile2.destroyPos, this.f_9244_.m_8055_(tile2.destroyPos), action, true, "actual start of destroying"));
                tile2.lastSentState = i;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.f_9251_)) {
                int j = this.f_9252_ - this.f_9250_;
                BlockState state2 = this.f_9244_.m_8055_(pos);
                if (!state2.m_60795_()) {
                    float f1 = state2.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, pos) * (float)(j + 1);
                    if (f1 >= 0.7f) {
                        for (HammerTile tile3 : this.hammer.tiles) {
                            tile3.isDestroyingBlock = false;
                            this.f_9244_.m_6801_(-1, tile3.destroyPos, -1);
                            BlockState state3 = this.f_9244_.m_8055_(tile3.destroyPos);
                            float f2 = state3.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, tile3.destroyPos) * (float)(this.f_9252_ - tile3.destroyProgressStart + 1);
                            if (!(f2 >= f1)) continue;
                            this.m_9286_(tile3.destroyPos, action, "destroyed");
                        }
                        return;
                    }
                    if (!this.f_9253_) {
                        for (HammerTile tile4 : this.hammer.tiles) {
                            tile4.isDestroyingBlock = false;
                        }
                    }
                }
            }
            for (HammerTile tile5 : this.hammer.tiles) {
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile5.destroyPos, this.f_9244_.m_8055_(tile5.destroyPos), action, true, "stopped destroying"));
            }
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.hammer.tiles.removeIf(tile -> {
                this.f_9244_.m_6801_(-1, tile.destroyPos, -1);
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile.destroyPos, this.f_9244_.m_8055_(tile.destroyPos), action, true, "aborted destroying"));
                return true;
            });
        }
    }

    private boolean hasHammer(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.TOOL) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        return data.get(ModGearAttributes.HAMMERING, VaultGearAttributeTypeMerger.anyTrue());
    }

    private boolean hasHydroVoid(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.TOOL) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        return data.get(ModGearAttributes.HYDROVOID, VaultGearAttributeTypeMerger.anyTrue());
    }

    private void computeHammerTiles(BlockPos pos, Direction facing, int buildHeight) {
        ToolItem.getHammerPositions(this.f_9245_.m_21205_(), pos, facing, (Entity)this.f_9245_).forEachRemaining(p -> {
            if (!p.equals((Object)pos)) {
                this.hammer.tiles.add(new HammerTile(true, this.f_9252_, (BlockPos)p, -1));
            }
        });
    }

    @Redirect(method={"removeBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;"))
    private FluidState removeBlock(ServerLevel instance, BlockPos pos) {
        if (this.hasHydroVoid(this.f_9245_)) {
            return Fluids.f_76191_.m_76145_();
        }
        return instance.m_6425_(pos);
    }
}

