/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class MixinWorldRenderer {
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;

    @Inject(method={"destroyBlockProgress"}, at={@At(value="HEAD")}, cancellable=true)
    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress, CallbackInfo ci) {
        if (breakerId != -1) {
            return;
        }
        if (progress >= 0 && progress < 10) {
            SortedSet set = (SortedSet)this.f_109409_.computeIfAbsent(pos.m_121878_(), key -> Sets.newTreeSet());
            if (set.isEmpty() || ((BlockDestructionProgress)set.last()).m_139988_() < progress) {
                set.clear();
                BlockDestructionProgress result = new BlockDestructionProgress(breakerId, pos);
                result.m_139981_(progress);
                set.add(result);
            }
        } else {
            this.f_109409_.remove(pos.m_121878_());
        }
        ci.cancel();
    }

    @Inject(method={"removeProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeProgress(BlockDestructionProgress progress, CallbackInfo ci) {
        long i = progress.m_139985_().m_121878_();
        Set set = (Set)this.f_109409_.get(i);
        if (set == null) {
            ci.cancel();
        }
    }
}

