/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.ChainingParticle;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundAlchemySecondParticleMessage {
    public final BlockPos pos;
    public final int color;

    public ClientboundAlchemySecondParticleMessage(BlockPos pos, int color) {
        this.pos = pos;
        this.color = color;
    }

    public static void encode(ClientboundAlchemySecondParticleMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeInt(message.color);
    }

    public static ClientboundAlchemySecondParticleMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundAlchemySecondParticleMessage(buffer.m_130135_(), buffer.readInt());
    }

    public static void handle(ClientboundAlchemySecondParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundAlchemySecondParticleMessage.renderParticles(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderParticles(ClientboundAlchemySecondParticleMessage message) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ClientboundAlchemySecondParticleMessage.renderParticlesSecond(message.pos, (Level)level, message.color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderParticlesSecond(BlockPos pos, Level level, int color) {
        for (int i = 0; i < 30; ++i) {
            Random random = level.m_5822_();
            float rotation = random.nextFloat() * 360.0f;
            float length = random.nextFloat() / 5.0f + 0.1f;
            Vec3 offset = new Vec3(Math.cos(rotation) * (double)length, 0.0, Math.sin(rotation) * (double)length);
            Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.CHAINING.get(), (double)pos.m_123341_() + 0.5 + offset.f_82479_ / 20.0, (double)pos.m_123342_() + 0.9 + (double)(-0.05f + random.nextFloat() * 0.1f), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            if (!(particle instanceof ChainingParticle)) continue;
            ChainingParticle alchemyTableParticle = (ChainingParticle)particle;
            alchemyTableParticle.m_107253_((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            alchemyTableParticle.m_172260_(offset.f_82479_ / 3.0, -0.01f + random.nextFloat() * 0.02f, offset.f_82481_ / 3.0);
            alchemyTableParticle.m_107257_(10);
        }
    }
}

