/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.ArtifactBossImmunityParticleOptions;
import iskallia.vault.init.ModParticles;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundArtifactBossImmunityParticleMessage {
    public final Vec3 pos;
    public final int color;
    public final int color2;

    public ClientboundArtifactBossImmunityParticleMessage(Vec3 pos, int color, int color2) {
        this.pos = pos;
        this.color = color;
        this.color2 = color2;
    }

    public static void encode(ClientboundArtifactBossImmunityParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.pos.f_82479_);
        buffer.writeDouble(message.pos.f_82480_);
        buffer.writeDouble(message.pos.f_82481_);
        buffer.writeInt(message.color);
        buffer.writeInt(message.color2);
    }

    public static ClientboundArtifactBossImmunityParticleMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundArtifactBossImmunityParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readInt(), buffer.readInt());
    }

    public static void handle(ClientboundArtifactBossImmunityParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundArtifactBossImmunityParticleMessage.renderParticles(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderParticles(ClientboundArtifactBossImmunityParticleMessage message) {
        ClientboundArtifactBossImmunityParticleMessage.renderParticlesFirst(new Vec3(message.pos.f_82479_, message.pos.f_82480_, message.pos.f_82481_), message.color, message.color2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderParticlesFirst(Vec3 pos, int color, int color2) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
            float b2 = (float)(color2 & 0xFF) / 255.0f;
            for (int i = 0; i < 40; ++i) {
                Vec3 vec33 = new Vec3(4.0, 9.0, 0.0).m_82524_((float)Math.toRadians((float)i * 9.0f + 180.0f));
                level.m_6493_((ParticleOptions)new ArtifactBossImmunityParticleOptions((ParticleType<ArtifactBossImmunityParticleOptions>)((ParticleType)ModParticles.ARTIFACT_BOSS_IMMUNITY.get()), 15, new Vector3f(r, g, b), new Vector3f(r2, g2, b2)), true, pos.f_82479_, pos.f_82480_ - 0.5, pos.f_82481_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_);
            }
        }
    }
}

