/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.entity.boss.ArtifactBossEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundBossStagesMessage {
    private final int entityId;
    private final List<CompoundTag> stagesNbt;

    public ClientboundBossStagesMessage(int entityId, List<CompoundTag> stagesNbt) {
        this.entityId = entityId;
        this.stagesNbt = stagesNbt;
    }

    public static void encode(ClientboundBossStagesMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.m_178352_(message.stagesNbt, FriendlyByteBuf::m_130079_);
    }

    public static ClientboundBossStagesMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundBossStagesMessage(buffer.readInt(), (List)buffer.m_178371_(ArrayList::new, FriendlyByteBuf::m_130260_));
    }

    public static void handle(ClientboundBossStagesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundBossStagesMessage.updateStages(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateStages(ClientboundBossStagesMessage message) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(message.entityId)) instanceof ArtifactBossEntity) {
            ArtifactBossEntity artifactBossEntity = (ArtifactBossEntity)entity;
            artifactBossEntity.setStagesFromNbt(message.stagesNbt);
        }
    }
}

