/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.entity.champion.ChampionAffixRegistry;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.entity.champion.IChampionAffix;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundChampionMessage {
    private final int entityId;
    private final List<IChampionAffix> affixes;

    public ClientboundChampionMessage(int entityId, List<IChampionAffix> affixes) {
        this.entityId = entityId;
        this.affixes = affixes;
    }

    public static void encode(ClientboundChampionMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.m_178352_(message.affixes, (buf, affix) -> buf.m_130079_(affix.serialize()));
    }

    public static ClientboundChampionMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundChampionMessage(buffer.readInt(), (List)buffer.m_178371_(size -> new ArrayList(), buf -> ChampionAffixRegistry.deserialize(buf.m_130260_()).orElseThrow()));
    }

    public static void handle(ClientboundChampionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundChampionMessage.updateAffixes(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateAffixes(ClientboundChampionMessage message) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(message.entityId)) instanceof ChampionLogic.IChampionLogicHolder) {
            ChampionLogic.IChampionLogicHolder championLogicHolder = (ChampionLogic.IChampionLogicHolder)entity;
            entity.m_19880_().add("vault_champion");
            championLogicHolder.getChampionLogic().setAffixes(message.affixes);
        }
    }
}

