/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundMobEffectUpdateMessage {
    private final int entityId;
    private final MobEffect effect;
    private final byte effectAmplifier;
    private final int effectDurationTicks;
    private final byte flags;

    public ClientboundMobEffectUpdateMessage(int entityId, MobEffectInstance effectInstance) {
        this.entityId = entityId;
        this.effect = effectInstance.m_19544_();
        this.effectAmplifier = (byte)(effectInstance.m_19564_() & 0xFF);
        this.effectDurationTicks = effectInstance.m_19557_() > Short.MAX_VALUE ? Short.MAX_VALUE : effectInstance.m_19557_();
        byte flags = 0;
        if (effectInstance.m_19571_()) {
            flags = (byte)(flags | 1);
        }
        if (effectInstance.m_19572_()) {
            flags = (byte)(flags | 2);
        }
        if (effectInstance.m_19575_()) {
            flags = (byte)(flags | 4);
        }
        this.flags = flags;
    }

    public ClientboundMobEffectUpdateMessage(int entityId, MobEffect effect, byte effectAmplifier, int effectDurationTicks, byte flags) {
        this.entityId = entityId;
        this.effect = effect;
        this.effectAmplifier = effectAmplifier;
        this.effectDurationTicks = effectDurationTicks;
        this.flags = flags;
    }

    public static void encode(ClientboundMobEffectUpdateMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.entityId);
        buffer.m_130130_(MobEffect.m_19459_((MobEffect)message.effect));
        buffer.writeByte((int)message.effectAmplifier);
        buffer.m_130130_(message.effectDurationTicks);
        buffer.writeByte((int)message.flags);
    }

    public static ClientboundMobEffectUpdateMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundMobEffectUpdateMessage(buffer.m_130242_(), MobEffect.m_19453_((int)buffer.m_130242_()), buffer.readByte(), buffer.m_130242_(), buffer.readByte());
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }

    public static void handle(ClientboundMobEffectUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (message.effect == null) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(message.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            MobEffectInstance mobeffectinstance = new MobEffectInstance(message.effect, message.effectDurationTicks, (int)message.effectAmplifier, message.isEffectAmbient(), message.isEffectVisible(), message.effectShowsIcon());
            mobeffectinstance.m_19562_(message.effectDurationTicks == Short.MAX_VALUE);
            livingEntity.m_147215_(mobeffectinstance, null);
        });
        context.setPacketHandled(true);
    }
}

