/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundPlayerLastDamageSourceMessage {
    private static final BiMap<Byte, DamageSource> DAMAGE_SOURCES = HashBiMap.create();
    private final DamageSource damageSource;

    public ClientboundPlayerLastDamageSourceMessage(DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    public static void encode(ClientboundPlayerLastDamageSourceMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)((Byte)DAMAGE_SOURCES.inverse().get((Object)message.damageSource)).byteValue());
    }

    public static ClientboundPlayerLastDamageSourceMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundPlayerLastDamageSourceMessage((DamageSource)DAMAGE_SOURCES.get((Object)buffer.readByte()));
    }

    public static void handle(ClientboundPlayerLastDamageSourceMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundPlayerLastDamageSourceMessage.updatePlayerDamageSource(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updatePlayerDamageSource(ClientboundPlayerLastDamageSourceMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.f_20958_ = message.damageSource;
            player.f_20930_ = player.f_19853_.m_46467_();
        }
    }

    static {
        DAMAGE_SOURCES.put((Object)0, (Object)DamageSource.f_19319_);
        DAMAGE_SOURCES.put((Object)1, (Object)DamageSource.f_19320_);
    }
}

