/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientSkillAltarData;
import iskallia.vault.world.data.SkillAltarData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncSkillAltarDataMessage {
    private final Map<UUID, List<SkillAltarData.SkillIcon>> playerAbilityIconKeys;

    public ClientboundSyncSkillAltarDataMessage(UUID playerId, List<SkillAltarData.SkillIcon> abilityIconKeys) {
        this.playerAbilityIconKeys = Map.of(playerId, abilityIconKeys);
    }

    public ClientboundSyncSkillAltarDataMessage(Map<UUID, List<SkillAltarData.SkillIcon>> playerAbilityIconKeys) {
        this.playerAbilityIconKeys = playerAbilityIconKeys;
    }

    public static void encode(ClientboundSyncSkillAltarDataMessage message, FriendlyByteBuf buffer) {
        buffer.m_178352_(message.playerAbilityIconKeys.entrySet(), (buf, entry) -> {
            buf.m_130077_((UUID)entry.getKey());
            buf.m_178352_((Collection)entry.getValue(), (b, icon) -> icon.writeTo((FriendlyByteBuf)b));
        });
    }

    public static ClientboundSyncSkillAltarDataMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundSyncSkillAltarDataMessage(buffer.m_178368_(FriendlyByteBuf::m_130259_, buf -> buf.m_178366_(SkillAltarData.SkillIcon::readFrom)));
    }

    public static void handle(ClientboundSyncSkillAltarDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundSyncSkillAltarDataMessage.updatePlayerAbilityIconKeys(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updatePlayerAbilityIconKeys(ClientboundSyncSkillAltarDataMessage message) {
        message.playerAbilityIconKeys.forEach(ClientSkillAltarData::setAbilityIconKeys);
    }
}

