/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.ModifierDiscoveryTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class DiscoverModifierMessage {
    private final BlockPos pos;
    private final Tuple<Item, ResourceLocation> gearModifier;

    public DiscoverModifierMessage(BlockPos pos, Tuple<Item, ResourceLocation> gearModifier) {
        this.pos = pos;
        this.gearModifier = gearModifier;
    }

    public static void encode(DiscoverModifierMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130070_(((Item)message.gearModifier.m_14418_()).getRegistryName().toString());
        buffer.m_130070_(((ResourceLocation)message.gearModifier.m_14419_()).toString());
    }

    public static DiscoverModifierMessage decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        return new DiscoverModifierMessage(pos, (Tuple<Item, ResourceLocation>)new Tuple((Object)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(buffer.m_130277_()))), (Object)new ResourceLocation(buffer.m_130277_())));
    }

    public static void handle(DiscoverModifierMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            BlockPos pos = message.pos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (tile instanceof ModifierDiscoveryTileEntity) {
                ModifierDiscoveryTileEntity modifierDiscoveryTile = (ModifierDiscoveryTileEntity)tile;
                modifierDiscoveryTile.discoverGearModifier(player, message.gearModifier);
            }
        });
        context.setPacketHandled(true);
    }
}

