/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientForgeRecipesData;
import iskallia.vault.config.entry.recipe.ConfigForgeRecipe;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeRecipeSyncMessage {
    private final List<? extends VaultForgeRecipe> recipes;
    private final ForgeRecipeType type;

    public ForgeRecipeSyncMessage(List<? extends VaultForgeRecipe> recipes, ForgeRecipeType type) {
        this.recipes = recipes;
        this.type = type;
    }

    public static ForgeRecipeSyncMessage fromConfig(List<? extends ConfigForgeRecipe> configuredRecipes, ForgeRecipeType type) {
        ArrayList recipes = new ArrayList();
        configuredRecipes.forEach(recipe -> recipes.add(recipe.makeRecipe()));
        return new ForgeRecipeSyncMessage(recipes, type);
    }

    public static void encode(ForgeRecipeSyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_178352_(message.recipes, (buf, recipe) -> recipe.write((FriendlyByteBuf)buf));
        buffer.m_130068_((Enum)message.type);
    }

    public static ForgeRecipeSyncMessage decode(FriendlyByteBuf buffer) {
        return new ForgeRecipeSyncMessage(buffer.m_178366_(VaultForgeRecipe::read), (ForgeRecipeType)buffer.m_130066_(ForgeRecipeType.class));
    }

    public static void handle(ForgeRecipeSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientForgeRecipesData.receiveMessage(message.recipes, message.type));
        context.setPacketHandled(true);
    }
}

