/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientInvalidConfigAlert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class InvalidConfigsMessage {
    private final Collection<String> invalidConfigList;

    public InvalidConfigsMessage(Collection<String> invalidConfigList) {
        this.invalidConfigList = invalidConfigList;
    }

    public static void encode(InvalidConfigsMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.invalidConfigList.size());
        for (String config : message.invalidConfigList) {
            buffer.m_130070_(config);
        }
    }

    public static InvalidConfigsMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<String> invalidConfigList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            invalidConfigList.add(buffer.m_130277_());
        }
        return new InvalidConfigsMessage(invalidConfigList);
    }

    public static void handle(InvalidConfigsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientInvalidConfigAlert.showAlert(message.invalidConfigList));
        context.setPacketHandled(true);
    }
}

