/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.LuckyHitDrainParticle;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class LuckyHitManaParticleMessage {
    private final Vec3 playerPos;
    private final int entityID;
    private final int color;
    private final int count;
    private final float yOffset;

    public LuckyHitManaParticleMessage(Vec3 playerPos, int entityID, int color, int count, float yOffset) {
        this.playerPos = playerPos;
        this.entityID = entityID;
        this.color = color;
        this.count = count;
        this.yOffset = yOffset;
    }

    public static void encode(LuckyHitManaParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeInt(message.entityID);
        buffer.writeInt(message.color);
        buffer.writeInt(message.count);
        buffer.writeDouble((double)message.yOffset);
    }

    public static LuckyHitManaParticleMessage decode(FriendlyByteBuf buffer) {
        return new LuckyHitManaParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readFloat());
    }

    public static void handle(LuckyHitManaParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                LuckyHitManaParticleMessage.spawnParticles(message.playerPos, message.entityID, message.color, message.count, message.yOffset);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, int entityID, int color, int count, float yOffset) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        Entity entity = level.m_6815_(entityID);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (int i = 0; i < count; ++i) {
                float rotation = random.nextFloat() * 360.0f;
                float radius = random.nextFloat();
                Vec3 offset = new Vec3((double)(radius / 5.0f) * Math.cos(rotation), 0.0, (double)(radius / 5.0f) * Math.sin(rotation));
                offset.m_82490_(random.nextDouble() + 0.5);
                Particle particle = pe.m_107370_((ParticleOptions)ModParticles.LUCKY_HIT_MANA.get(), pos.m_7096_(), pos.m_7098_() - random.nextDouble() * 0.6 - 0.15 + (double)yOffset, pos.m_7094_(), offset.f_82479_ / 2.0, random.nextDouble() * 0.25 + 0.1, offset.f_82481_ / 2.0);
                if (!(particle instanceof LuckyHitDrainParticle)) continue;
                LuckyHitDrainParticle pylonParticle = (LuckyHitDrainParticle)particle;
                pylonParticle.setLivingEntity(livingEntity);
                pylonParticle.m_107257_(20 + (int)(new Random().nextFloat() * 20.0f));
                pylonParticle.m_107253_((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }
        }
    }
}

