/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class LuckyHitVortexParticleMessage {
    private final Vec3 centerPos;
    private final float radius;

    public LuckyHitVortexParticleMessage(Vec3 centerPos, float radius) {
        this.centerPos = centerPos;
        this.radius = radius;
    }

    public static void encode(LuckyHitVortexParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.centerPos.f_82479_);
        buffer.writeDouble(message.centerPos.f_82480_);
        buffer.writeDouble(message.centerPos.f_82481_);
        buffer.writeFloat(message.radius);
    }

    public static LuckyHitVortexParticleMessage decode(FriendlyByteBuf buffer) {
        return new LuckyHitVortexParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat());
    }

    public static void handle(LuckyHitVortexParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                LuckyHitVortexParticleMessage.spawnParticles(message.centerPos, message.radius);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, float radius) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        ParticleEngine pm = Minecraft.m_91087_().f_91061_;
        for (int i = 0; i < 65; ++i) {
            float rotation = random.nextFloat() * 360.0f;
            Vec3 offset = new Vec3((double)radius * Math.cos(rotation), 0.25, (double)radius * Math.sin(rotation));
            float f = -0.5f + random.nextFloat() + (float)offset.m_7096_();
            float f1 = -0.5f + random.nextFloat() + (float)offset.m_7098_();
            float f2 = -0.5f + random.nextFloat() + (float)offset.m_7094_();
            Particle particle = pm.m_107370_((ParticleOptions)ModParticles.LUCKY_HIT_VORTEX.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)f, (double)f1, (double)f2);
            if (particle == null) continue;
            particle.m_107253_(0.5f, 0.0f, 1.0f);
        }
    }
}

