/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MobCritParticleMessage {
    private final Vec3 pos;

    public MobCritParticleMessage(Vec3 pos) {
        this.pos = pos;
    }

    public static void encode(MobCritParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.pos.f_82479_);
        buffer.writeDouble(message.pos.f_82480_);
        buffer.writeDouble(message.pos.f_82481_);
    }

    public static MobCritParticleMessage decode(FriendlyByteBuf buffer) {
        return new MobCritParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public static void handle(MobCritParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                MobCritParticleMessage.spawnParticles(message.pos);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        float radius = 1.0f;
        int num = 7;
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        for (int i = 0; i < num; ++i) {
            float rotation = (float)i / (float)num * 360.0f + (random.nextFloat() * 5.0f - 2.5f);
            Vec3 offset = new Vec3((double)(radius / 3.0f) * Math.cos(rotation), 0.0, (double)(radius / 3.0f) * Math.sin(rotation));
            Particle p = mgr.m_107370_((ParticleOptions)ModParticles.LUCKY_HIT.get(), pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_, random.nextDouble() * 0.5, offset.f_82481_);
            if (p == null) continue;
            p.m_107253_(0.75f, 0.1f, 0.1f);
        }
    }
}

