/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.ModifierWorkbenchTileEntity;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ModifierWorkbenchHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ModifierWorkbenchCraftMessage {
    private final BlockPos pos;
    @Nullable
    private final ResourceLocation craftModifierIdentifier;

    public ModifierWorkbenchCraftMessage(BlockPos pos, @Nullable ResourceLocation craftModifierIdentifier) {
        this.pos = pos;
        this.craftModifierIdentifier = craftModifierIdentifier;
    }

    public static void encode(ModifierWorkbenchCraftMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_182687_(Optional.ofNullable(message.craftModifierIdentifier), FriendlyByteBuf::m_130085_);
    }

    public static ModifierWorkbenchCraftMessage decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ResourceLocation key = buffer.m_182698_(FriendlyByteBuf::m_130281_).orElse(null);
        return new ModifierWorkbenchCraftMessage(pos, key);
    }

    public static void handle(ModifierWorkbenchCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            BlockPos pos = message.pos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (!(tile instanceof ModifierWorkbenchTileEntity)) {
                return;
            }
            ModifierWorkbenchTileEntity workbenchTile = (ModifierWorkbenchTileEntity)tile;
            ItemStack input = workbenchTile.getInventory().m_8020_(0);
            if (input.m_41619_() || !(input.m_41720_() instanceof VaultGearItem) || !AttributeGearData.hasData(input)) {
                return;
            }
            if (!VaultGearData.read(input).isModifiable()) {
                return;
            }
            VaultGearWorkbenchConfig.getConfig(input.m_41720_()).ifPresent(cfg -> {
                ItemStack inputCopy = input.m_41777_();
                VaultGearModifier.AffixType targetAffix = null;
                VaultGearModifier createdModifier = null;
                ArrayList<ItemStack> cost = new ArrayList<ItemStack>();
                if (message.craftModifierIdentifier == null) {
                    if (!ModifierWorkbenchHelper.hasCraftedModifier(inputCopy)) {
                        return;
                    }
                    cost.addAll(cfg.getCostRemoveCraftedModifiers());
                } else {
                    VaultGearWorkbenchConfig.CraftableModifierConfig modifierConfig = cfg.getConfig(message.craftModifierIdentifier);
                    if (modifierConfig == null) {
                        return;
                    }
                    if (!modifierConfig.hasPrerequisites((Player)player)) {
                        return;
                    }
                    boolean hadCraftedModifiers = ModifierWorkbenchHelper.hasCraftedModifier(inputCopy);
                    ModifierWorkbenchHelper.removeCraftedModifiers(inputCopy);
                    VaultGearData data = VaultGearData.read(inputCopy);
                    if (data.getItemLevel() < modifierConfig.getMinLevel()) {
                        return;
                    }
                    targetAffix = modifierConfig.getAffixGroup().getTargetAffixType();
                    if (targetAffix == VaultGearModifier.AffixType.PREFIX ? !VaultGearModifierHelper.hasOpenPrefix(inputCopy) : !VaultGearModifierHelper.hasOpenSuffix(inputCopy)) {
                        return;
                    }
                    createdModifier = modifierConfig.createModifier().orElse(null);
                    if (createdModifier == null) {
                        return;
                    }
                    Set<String> existingModGroups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
                    if (existingModGroups.contains(createdModifier.getModifierGroup())) {
                        return;
                    }
                    cost.addAll(modifierConfig.createCraftingCost(inputCopy));
                    if (hadCraftedModifiers) {
                        cost.addAll(cfg.getCostRemoveCraftedModifiers());
                    }
                }
                List<ItemStack> missing = InventoryUtil.getMissingInputs(cost, player.m_150109_());
                if (!missing.isEmpty()) {
                    return;
                }
                if (!InventoryUtil.consumeInputs(cost, player.m_150109_(), true)) {
                    return;
                }
                if (InventoryUtil.consumeInputs(cost, player.m_150109_(), false)) {
                    if (createdModifier == null) {
                        ModifierWorkbenchHelper.removeCraftedModifiers(input);
                    } else {
                        createdModifier.setCategory(VaultGearModifier.AffixCategory.CRAFTED);
                        createdModifier.setGameTimeAdded(player.m_183503_().m_46467_());
                        ModifierWorkbenchHelper.removeCraftedModifiers(input);
                        VaultGearData data = VaultGearData.read(input);
                        data.addModifier(targetAffix, createdModifier);
                        data.write(input);
                    }
                    player.m_183503_().m_46796_(1030, tile.m_58899_(), 0);
                }
            });
        });
        context.setPacketHandled(true);
    }
}

