/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class NovaParticleMessage {
    private final Vec3 playerPos;
    private final float radius;

    public NovaParticleMessage(Vec3 playerPos, float radius) {
        this.playerPos = playerPos;
        this.radius = radius;
    }

    public static void encode(NovaParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeFloat(message.radius);
    }

    public static NovaParticleMessage decode(FriendlyByteBuf buffer) {
        return new NovaParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat());
    }

    public static void handle(NovaParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                NovaParticleMessage.spawnParticles(message.playerPos, message.radius);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, float radius) {
        Vec3 offset;
        float rotation;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        for (i = 0; i < 140; ++i) {
            rotation = random.nextFloat() * 360.0f;
            offset = new Vec3((double)(radius / 5.0f) * Math.cos(rotation), 0.0, (double)(radius / 5.0f) * Math.sin(rotation));
            level.m_6493_((ParticleOptions)ModParticles.NOVA_WAVE.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
            level.m_6493_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
            offset = new Vec3((double)(radius / 8.0f) * Math.cos(rotation), 0.0, (double)(radius / 8.0f) * Math.sin(rotation));
            level.m_6493_((ParticleOptions)ModParticles.NOVA_WAVE.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
            level.m_6493_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
        }
        for (i = 0; i < 10; ++i) {
            rotation = random.nextFloat() * 360.0f;
            offset = new Vec3((double)(radius / 15.0f) * Math.cos(rotation), 0.0, (double)(radius / 15.0f) * Math.sin(rotation));
            level.m_6493_((ParticleOptions)ModParticles.NOVA.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
            offset = new Vec3((double)(radius / 8.0f) * Math.cos(rotation), 0.0, (double)(radius / 8.0f) * Math.sin(rotation));
            level.m_6493_((ParticleOptions)ModParticles.NOVA.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
        }
    }
}

