/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.LootStatueTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class OmegaStatueUIMessage {
    public Opcode opcode;
    public CompoundTag payload;

    public static void encode(OmegaStatueUIMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.opcode.ordinal());
        buffer.m_130079_(message.payload);
    }

    public static OmegaStatueUIMessage decode(FriendlyByteBuf buffer) {
        OmegaStatueUIMessage message = new OmegaStatueUIMessage();
        message.opcode = Opcode.values()[buffer.readInt()];
        message.payload = buffer.m_130260_();
        return message;
    }

    public static void handle(OmegaStatueUIMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (message.opcode == Opcode.SELECT_ITEM) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)message.payload.m_128469_("Item"));
                BlockPos statuePos = NbtUtils.m_129239_((CompoundTag)message.payload.m_128469_("Position"));
                ServerLevel world = context.getSender().m_183503_();
                BlockEntity te = world.m_7702_(statuePos);
                if (te instanceof LootStatueTileEntity) {
                    ((LootStatueTileEntity)te).setLootItem(stack);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static OmegaStatueUIMessage selectItem(ItemStack stack, BlockPos statuePos) {
        OmegaStatueUIMessage message = new OmegaStatueUIMessage();
        message.opcode = Opcode.SELECT_ITEM;
        message.payload = new CompoundTag();
        message.payload.m_128365_("Item", (Tag)stack.serializeNBT());
        message.payload.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)statuePos));
        return message;
    }

    public static enum Opcode {
        SELECT_ITEM;

    }
}

