/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.PylonConsumeParticle;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PylonConsumeParticleMessage {
    private final Vec3 playerPos;
    private final int entityID;
    private final int color;

    public PylonConsumeParticleMessage(Vec3 playerPos, int entityID, int color) {
        this.playerPos = playerPos;
        this.entityID = entityID;
        this.color = color;
    }

    public static void encode(PylonConsumeParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeInt(message.entityID);
        buffer.writeInt(message.color);
    }

    public static PylonConsumeParticleMessage decode(FriendlyByteBuf buffer) {
        return new PylonConsumeParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readInt(), buffer.readInt());
    }

    public static void handle(PylonConsumeParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                PylonConsumeParticleMessage.spawnParticles(message.playerPos, message.entityID, message.color);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, int entityID, int color) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        Entity entity = level.m_6815_(entityID);
        if (entity instanceof LivingEntity) {
            float rotation;
            int i;
            LivingEntity livingEntity = (LivingEntity)entity;
            for (i = 0; i < 80; ++i) {
                rotation = random.nextFloat() * 360.0f;
                float radius = 1.0f + random.nextFloat();
                Vec3 offset = new Vec3((double)(radius / 5.0f) * Math.cos(rotation), 0.0, (double)(radius / 5.0f) * Math.sin(rotation));
                offset.m_82490_(random.nextDouble() + 0.5);
                Particle particle = pe.m_107370_((ParticleOptions)ModParticles.PYLON_CONSUME.get(), pos.m_7096_() + 0.5, pos.m_7098_() + random.nextDouble() * 0.6 + 0.15, pos.m_7094_() + 0.5, offset.f_82479_ / 2.0, random.nextDouble() * 0.25 + 0.1, offset.f_82481_ / 2.0);
                if (!(particle instanceof PylonConsumeParticle)) continue;
                PylonConsumeParticle pylonParticle = (PylonConsumeParticle)particle;
                pylonParticle.setLivingEntity(livingEntity);
                pylonParticle.m_107253_((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }
            for (i = 0; i < 12; ++i) {
                rotation = random.nextFloat() * 360.0f;
                Vec3 offset = new Vec3((double)0.4f * Math.cos(rotation), 0.0, (double)0.4f * Math.sin(rotation));
                offset.m_82490_(random.nextDouble() + 0.5);
                Particle particle = pe.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), pos.m_7096_() + 0.5 + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.125, offset.f_82481_ / 8.0);
                if (particle != null) {
                    particle.m_107257_(60 + random.nextInt(20));
                }
                offset = new Vec3(0.25 * Math.cos(rotation), 0.0, 0.25 * Math.sin(rotation));
                offset.m_82490_(random.nextDouble() + 0.5);
                particle = pe.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), pos.m_7096_() + 0.5 + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.125, offset.f_82481_ / 8.0);
                if (particle == null) continue;
                particle.m_107257_(60 + random.nextInt(20));
            }
        }
    }
}

