/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.EternalPedestalTileEntity;
import iskallia.vault.block.entity.LootStatueTileEntity;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.util.RenameType;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class RenameUIMessage {
    public RenameType renameType;
    public CompoundTag payload;

    public static void encode(RenameUIMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.renameType.ordinal());
        buffer.m_130079_(message.payload);
    }

    public static RenameUIMessage decode(FriendlyByteBuf buffer) {
        RenameUIMessage message = new RenameUIMessage();
        message.renameType = RenameType.values()[buffer.readInt()];
        message.payload = buffer.m_130260_();
        return message;
    }

    public static void handle(RenameUIMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            CompoundTag data = message.payload.m_128469_("Data");
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            switch (message.renameType) {
                case PLAYER_STATUE: {
                    BlockPos statuePos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Pos"));
                    BlockEntity te = sender.m_20193_().m_7702_(statuePos);
                    if (!(te instanceof LootStatueTileEntity)) break;
                    LootStatueTileEntity statue = (LootStatueTileEntity)te;
                    statue.getSkin().updateSkin(data.m_128461_("PlayerNickname"));
                    statue.sendUpdates();
                    break;
                }
                case VAULT_CRYSTAL: {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)data);
                    if (!(stack.m_41720_() instanceof VaultCrystalItem)) {
                        sender.m_6352_((Component)new TextComponent("Nice try, nerd!").m_130940_(ChatFormatting.RED), Util.f_137441_);
                        return;
                    }
                    sender.m_150109_().f_35974_.set(sender.m_150109_().f_35977_, (Object)stack);
                    break;
                }
                case CRYO_CHAMBER: {
                    BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("BlockPos"));
                    String name = data.m_128461_("EternalName");
                    BlockEntity te = sender.m_20193_().m_7702_(pos);
                    if (!(te instanceof EternalPedestalTileEntity)) break;
                    EternalPedestalTileEntity chamber = (EternalPedestalTileEntity)te;
                    chamber.renameEternal(name);
                    chamber.getSkinProfile().updateSkin(name);
                    chamber.sendUpdates();
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static RenameUIMessage updateName(RenameType type, CompoundTag nbt) {
        RenameUIMessage message = new RenameUIMessage();
        message.renameType = type;
        message.payload = nbt;
        return message;
    }
}

