/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundUpdateDifficultyMessage;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerboundChangeDifficultyMessage {
    private final VaultDifficulty vaultDifficulty;
    private final boolean vaultDifficultyLocked;

    public ServerboundChangeDifficultyMessage(VaultDifficulty vaultDifficulty, boolean vaultDifficultyLocked) {
        this.vaultDifficulty = vaultDifficulty;
        this.vaultDifficultyLocked = vaultDifficultyLocked;
    }

    public static void encode(ServerboundChangeDifficultyMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.vaultDifficulty.getId());
        buffer.writeBoolean(message.vaultDifficultyLocked);
    }

    public static ServerboundChangeDifficultyMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundChangeDifficultyMessage(VaultDifficulty.byId(buffer.readInt()), buffer.readBoolean());
    }

    public static void handle(ServerboundChangeDifficultyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender != null) {
                if (FMLEnvironment.dist == Dist.DEDICATED_SERVER && !sender.m_20310_(2)) {
                    sender.m_6352_((Component)new TextComponent("You do not have permission to change server difficulty.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                    return;
                }
                WorldSettings worldSettings = WorldSettings.get((Level)sender.m_183503_());
                worldSettings.setGlobalVaultDifficulty(message.vaultDifficulty);
                worldSettings.setVaultDifficultyLocked(message.vaultDifficultyLocked);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundUpdateDifficultyMessage(worldSettings.getGlobalVaultDifficulty(), worldSettings.isVaultDifficultyLocked()));
            }
        });
        context.setPacketHandled(true);
    }
}

