/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.archetype.AbstractArchetype;
import iskallia.vault.skill.archetype.AbstractArchetypeConfig;
import iskallia.vault.skill.archetype.ArchetypeContainer;
import iskallia.vault.skill.archetype.ArchetypeRegistry;
import iskallia.vault.world.data.PlayerArchetypeData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSelectArchetypeMessage {
    private final ResourceLocation archetypeId;

    public ServerboundSelectArchetypeMessage(ResourceLocation archetypeId) {
        this.archetypeId = archetypeId;
    }

    public static void encode(ServerboundSelectArchetypeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.archetypeId);
    }

    public static ServerboundSelectArchetypeMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundSelectArchetypeMessage(buffer.m_130281_());
    }

    public static void handle(ServerboundSelectArchetypeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || ServerVaults.get(player.f_19853_).isPresent()) {
                return;
            }
            PlayerArchetypeData archetypeData = PlayerArchetypeData.get(player.f_8924_);
            ArchetypeContainer archetypeContainer = archetypeData.getArchetypeContainer((Player)player);
            PlayerVaultStatsData playerSpeedrunStatsData = PlayerVaultStatsData.get(player.f_8924_);
            PlayerVaultStats vaultStats = playerSpeedrunStatsData.getVaultStats((Player)player);
            AbstractArchetype<?> archetype = ArchetypeRegistry.getArchetype(message.archetypeId);
            Object config = archetype.getConfig();
            int learningCost = ((AbstractArchetypeConfig)config).getLearningCost();
            int levelRequirement = ((AbstractArchetypeConfig)config).getLevelRequirement();
            int vaultLevel = vaultStats.getVaultLevel();
            if (archetypeContainer.getCurrentArchetype() == archetype) {
                return;
            }
            if (vaultLevel < levelRequirement) {
                return;
            }
            if (((AbstractArchetypeConfig)config).getLearningCost() > vaultStats.getUnspentArchetypePoints()) {
                return;
            }
            playerSpeedrunStatsData.spendArchetypePoints(player, learningCost);
            archetypeData.set(player, message.archetypeId);
        });
        context.setPacketHandled(true);
    }
}

